/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nutz.lang.Lang;
import org.nutz.lang.Nums;
import org.nutz.lang.meta.Email;

public class Strings {
    private static Pattern linePattern = Pattern.compile("_(\\w)");
    private static Pattern humpPattern = Pattern.compile("[A-Z]");
    protected static final Pattern reUnicode = Pattern.compile("\\\\u([0-9a-zA-Z]{4})");
    public static Pattern P_CitizenId = Pattern.compile("[1-9]\\d{5}[1-2]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}(\\d|X|x)");
    public static Pattern P_Mobile = Pattern.compile("^((13[0-9])|(15[0-9])|(14[0-9])|(17[0-9])|(18[0-9]))\\d{8}$");
    public static Pattern P_ZipCode = Pattern.compile("\\d{6}");
    public static Pattern P_Money = Pattern.compile("^(\\d+(?:\\.\\d+)?)$");
    public static Pattern P_Number = Pattern.compile("^[\\d]+$");
    public static Pattern P_Email = Pattern.compile("^([a-zA-Z0-9]*[-_]?[\\w.]+)*@([a-zA-Z0-9]*[-_]?[a-zA-Z0-9]+)+[\\\\.][A-Za-z]{2,3}([\\\\.][A-Za-z]{2})?$");
    public static Pattern P_QQ = Pattern.compile("[1-9][0-9]{4,10}");
    public static Pattern P_USCC = Pattern.compile("^(11|12|13|19|51|52|53|59|91|92|93|Y1)[1-9]{1}[0-9]{5}[0-9A-HJ-NP-RT-UW-Y0-9]{9}[0-90-9A-HJ-NP-RT-UW-Y]{1}$");
    public static Pattern P_UnionPayCard = Pattern.compile("^62[0-5]\\d{13,16}$");

    protected Strings() {
    }

    public static String line2Hump(String str) {
        str = str.toLowerCase();
        Matcher matcher = linePattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return Strings.upperFirst(sb.toString());
    }

    public static String hump2Line(String str) {
        str = Strings.lowerFirst(str);
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static boolean isChineseCharacter(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public static boolean isFullWidthCharacter(char c) {
        if (c == '\u3000' || c > '\uff00' && c < '\uff5f') {
            return true;
        }
        if (Strings.isChineseCharacter(c)) {
            return true;
        }
        return c >= '\u3040' && c <= '\u30ff';
    }

    public static char toHalfWidthCharacter(char c) {
        if (c == '\u3000') {
            return ' ';
        }
        if (c > '\uff00' && c < '\uff5f') {
            return (char)(c - 65248);
        }
        return c;
    }

    public static String toHalfWidthString(CharSequence str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            sb.append(Strings.toHalfWidthCharacter(str.charAt(i)));
        }
        return sb.toString();
    }

    public static boolean isFullWidthString(CharSequence str) {
        return Strings.charLength(str) == str.length() * 2;
    }

    public static boolean isHalfWidthString(CharSequence str) {
        return Strings.charLength(str) == str.length();
    }

    public static int charLength(CharSequence str) {
        int clength = 0;
        for (int i = 0; i < str.length(); ++i) {
            clength += Strings.isFullWidthCharacter(str.charAt(i)) ? 2 : 1;
        }
        return clength;
    }

    public static String dup(CharSequence cs, int num) {
        if (Strings.isEmpty(cs) || num <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(cs.length() * num);
        for (int i = 0; i < num; ++i) {
            sb.append(cs);
        }
        return sb.toString();
    }

    public static String dup(char c, int num) {
        if (c == '\u0000' || num < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder(num);
        for (int i = 0; i < num; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    @Deprecated
    public static String capitalize(CharSequence s) {
        return Strings.upperFirst(s);
    }

    public static String lowerFirst(CharSequence s) {
        if (null == s) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return "";
        }
        char c = s.charAt(0);
        if (Character.isLowerCase(c)) {
            return s.toString();
        }
        return new StringBuilder(len).append(Character.toLowerCase(c)).append(s.subSequence(1, len)).toString();
    }

    public static String upperFirst(CharSequence s) {
        if (null == s) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return "";
        }
        char c = s.charAt(0);
        if (Character.isUpperCase(c)) {
            return s.toString();
        }
        return new StringBuilder(len).append(Character.toUpperCase(c)).append(s.subSequence(1, len)).toString();
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equalsIgnoreCase(s2);
    }

    public static boolean equals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public static boolean startsWithChar(String s, char c) {
        return null != s ? (s.length() == 0 ? false : s.charAt(0) == c) : false;
    }

    public static boolean endsWithChar(String s, char c) {
        return null != s ? (s.length() == 0 ? false : s.charAt(s.length() - 1) == c) : false;
    }

    public static boolean isEmpty(CharSequence cs) {
        return null == cs || cs.length() == 0;
    }

    public static boolean isBlank(CharSequence cs) {
        if (null == cs) {
            return true;
        }
        int length = cs.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !Strings.isBlank(cs);
    }

    public static String trim(CharSequence cs) {
        int l;
        int last;
        if (null == cs) {
            return null;
        }
        int length = cs.length();
        if (length == 0) {
            return cs.toString();
        }
        int r = last = length - 1;
        for (l = 0; l < length && Character.isWhitespace(cs.charAt(l)); ++l) {
        }
        while (r > l && Character.isWhitespace(cs.charAt(r))) {
            --r;
        }
        if (l > r) {
            return "";
        }
        if (l == 0 && r == last) {
            return cs.toString();
        }
        return cs.subSequence(l, r + 1).toString();
    }

    public static String trimLeft(CharSequence cs) {
        int l;
        if (null == cs) {
            return null;
        }
        int length = cs.length();
        if (length == 0) {
            return cs.toString();
        }
        for (l = 0; l < length && Character.isWhitespace(cs.charAt(l)); ++l) {
        }
        if (length - 1 == l) {
            return "";
        }
        if (l > 0) {
            return cs.subSequence(l, length).toString();
        }
        return cs.toString();
    }

    public static String trimRight(CharSequence cs) {
        int last;
        int r;
        if (null == cs) {
            return null;
        }
        int length = cs.length();
        if (length == 0) {
            return cs.toString();
        }
        for (r = last = length - 1; r > 0 && Character.isWhitespace(cs.charAt(r)); --r) {
        }
        if (0 == r) {
            return "";
        }
        if (r == last) {
            return cs.toString();
        }
        return cs.subSequence(0, r + 1).toString();
    }

    public static String brief(String str, int len) {
        if (Strings.isBlank(str) || str.length() + 3 <= len) {
            return str;
        }
        int w = len / 2;
        int l = str.length();
        return str.substring(0, len - w) + " ... " + str.substring(l - w);
    }

    public static String[] splitIgnoreBlank(String s) {
        return Strings.splitIgnoreBlank(s, ",");
    }

    public static String[] splitIgnoreBlank(String s, String regex) {
        if (null == s) {
            return null;
        }
        String[] ss = s.split(regex);
        LinkedList<String> list = new LinkedList<String>();
        for (String st : ss) {
            if (Strings.isBlank(st)) continue;
            list.add(Strings.trim(st));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String fillDigit(int d, int width) {
        return Strings.alignRight(String.valueOf(d), width, '0');
    }

    public static String fillHex(int d, int width) {
        return Strings.alignRight(Integer.toHexString(d), width, '0');
    }

    public static String fillBinary(int d, int width) {
        return Strings.alignRight(Integer.toBinaryString(d), width, '0');
    }

    public static String toDigit(int d, int width) {
        return Strings.cutRight(String.valueOf(d), width, '0');
    }

    public static String toHex(int d, int width) {
        return Strings.cutRight(Integer.toHexString(d), width, '0');
    }

    public static String toBinary(int d, int width) {
        return Strings.cutRight(Integer.toBinaryString(d), width, '0');
    }

    public static String cutRight(String s, int width, char c) {
        if (null == s) {
            return null;
        }
        int len = s.length();
        if (len == width) {
            return s;
        }
        if (len < width) {
            return Strings.dup(c, width - len) + s;
        }
        return s.substring(len - width, len);
    }

    public static String cutLeft(String s, int width, char c) {
        if (null == s) {
            return null;
        }
        int len = s.length();
        if (len == width) {
            return s;
        }
        if (len < width) {
            return s + Strings.dup(c, width - len);
        }
        return s.substring(0, width);
    }

    public static String alignRight(Object o, int width, char c) {
        if (null == o) {
            return null;
        }
        String s = o.toString();
        int len = s.length();
        if (len >= width) {
            return s;
        }
        return Strings.dup(c, width - len) + s;
    }

    public static String alignLeft(Object o, int width, char c) {
        if (null == o) {
            return null;
        }
        String s = o.toString();
        int length = s.length();
        if (length >= width) {
            return s;
        }
        return s + Strings.dup(c, width - length);
    }

    public static boolean isQuoteByIgnoreBlank(CharSequence cs, char lc, char rc) {
        int l;
        int last;
        if (null == cs) {
            return false;
        }
        int len = cs.length();
        if (len < 2) {
            return false;
        }
        int r = last = len - 1;
        for (l = 0; l < len && Character.isWhitespace(cs.charAt(l)); ++l) {
        }
        if (cs.charAt(l) != lc) {
            return false;
        }
        while (r > l && Character.isWhitespace(cs.charAt(r))) {
            --r;
        }
        return l < r && cs.charAt(r) == rc;
    }

    public static boolean isQuoteBy(CharSequence cs, char lc, char rc) {
        if (null == cs) {
            return false;
        }
        int length = cs.length();
        return length > 1 && cs.charAt(0) == lc && cs.charAt(length - 1) == rc;
    }

    public static boolean isQuoteBy(String str, String l, String r) {
        if (null == str || null == l || null == r) {
            return false;
        }
        return str.startsWith(l) && str.endsWith(r);
    }

    public static int countStrHeadIndent(String str, int tabWidth) {
        int n = 0;
        if (!Strings.isEmpty(str)) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (' ' == c) {
                    ++n;
                    continue;
                }
                if ('\t' != c) break;
                n += tabWidth;
            }
        }
        return n / tabWidth;
    }

    public static int countStrHeadChar(String str, char c) {
        int re;
        if (!Strings.isEmpty(str)) {
            for (re = 0; re < str.length(); ++re) {
                if (str.charAt(re) == c) continue;
                return re;
            }
        }
        return re;
    }

    public static String shiftIndent(String str, int indent, int tabWidth) {
        int i;
        if (Strings.isEmpty(str)) {
            return str;
        }
        if (indent <= 0) {
            indent = 1;
        }
        int n = 0;
        for (i = 0; i < str.length() && (n <= 0 || n / tabWidth < indent); ++i) {
            char c = str.charAt(i);
            if (' ' == c) {
                ++n;
                continue;
            }
            if ('\t' != c) break;
            n += tabWidth;
        }
        if (i > 0) {
            return str.substring(i);
        }
        return str;
    }

    public static int maxLength(Collection<? extends CharSequence> coll) {
        int re = 0;
        if (null != coll) {
            for (CharSequence charSequence : coll) {
                if (null == charSequence) continue;
                re = Math.max(re, charSequence.length());
            }
        }
        return re;
    }

    public static <T extends CharSequence> int maxLength(T[] array) {
        int re = 0;
        if (null != array) {
            for (T s : array) {
                if (null == s) continue;
                re = Math.max(re, s.length());
            }
        }
        return re;
    }

    public static String sNull(Object obj) {
        return Strings.sNull(obj, "");
    }

    public static String sNull(Object obj, String def) {
        return obj != null ? obj.toString() : def;
    }

    public static String sBlank(Object obj) {
        return Strings.sBlank(obj, "");
    }

    public static String sBlank(Object obj, String def) {
        if (null == obj) {
            return def;
        }
        String s = obj.toString();
        return Strings.isBlank(s) ? def : s;
    }

    public static String removeFirst(CharSequence str) {
        if (str == null) {
            return null;
        }
        if (str.length() > 1) {
            return str.subSequence(1, str.length()).toString();
        }
        return "";
    }

    public static String removeFirst(String str, char c) {
        return Strings.isEmpty(str) || c != str.charAt(0) ? str : str.substring(1);
    }

    public static boolean isin(String[] ss, String s) {
        if (null == ss || ss.length == 0 || Strings.isBlank(s)) {
            return false;
        }
        for (String w : ss) {
            if (!s.equals(w)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isEmail(CharSequence input) {
        if (Strings.isBlank(input)) {
            return false;
        }
        try {
            new Email(input.toString());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String lowerWord(CharSequence cs, char c) {
        StringBuilder sb = new StringBuilder();
        int len = cs.length();
        for (int i = 0; i < len; ++i) {
            char ch = cs.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (i > 0) {
                    sb.append(c);
                }
                sb.append(Character.toLowerCase(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String upperWord(CharSequence cs, char c) {
        StringBuilder sb = new StringBuilder();
        int len = cs.length();
        for (int i = 0; i < len; ++i) {
            char ch = cs.charAt(i);
            if (ch == c) {
                do {
                    if (++i < len) continue;
                    return sb.toString();
                } while ((ch = cs.charAt(i)) == c);
                sb.append(Character.toUpperCase(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String escapeHtml(CharSequence cs) {
        if (null == cs) {
            return null;
        }
        char[] cas = cs.toString().toCharArray();
        StringBuilder sb = new StringBuilder();
        block7: for (char c : cas) {
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&#x27;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static byte[] getBytesUTF8(CharSequence cs) {
        try {
            return cs.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static String num2hex(int n) {
        String s = Integer.toHexString(n);
        return n <= 15 ? "0" + s : s;
    }

    public static int hex2num(String hex) {
        return Integer.parseInt(hex, 16);
    }

    public static <T> String join2(String sp, T[] array) {
        return Lang.concat((Object)sp, array).toString();
    }

    public static <T> String join(String sp, T ... array) {
        return Lang.concat((Object)sp, array).toString();
    }

    public static <T> String join(String sp, Collection<T> coll) {
        return Lang.concat((Object)sp, coll).toString();
    }

    private static String _formatSizeForRead(long size, double SZU) {
        if ((double)size < SZU) {
            return String.format("%d bytes", size);
        }
        double n = (double)size / SZU;
        if (n < SZU) {
            return String.format("%5.2f KB", n);
        }
        if ((n /= SZU) < SZU) {
            return String.format("%5.2f MB", n);
        }
        return String.format("%5.2f GB", n /= SZU);
    }

    public static String formatSizeForReadBy1024(long size) {
        return Strings._formatSizeForRead(size, 1024.0);
    }

    public static String formatSizeForReadBy1000(long size) {
        return Strings._formatSizeForRead(size, 1000.0);
    }

    public static String changeCharset(CharSequence cs, Charset newCharset) {
        if (cs != null) {
            byte[] bs = cs.toString().getBytes();
            return new String(bs, newCharset);
        }
        return null;
    }

    public static String evalEscape(String str) {
        StringBuilder sb = new StringBuilder();
        char[] cs = str.toCharArray();
        block7: for (int i = 0; i < cs.length; ++i) {
            char c = cs[i];
            if (c == '\\') {
                c = cs[++i];
                switch (c) {
                    case 'n': {
                        sb.append('\n');
                        continue block7;
                    }
                    case 'r': {
                        sb.append('\r');
                        continue block7;
                    }
                    case 't': {
                        sb.append('\t');
                        continue block7;
                    }
                    case 'b': {
                        sb.append('\b');
                        continue block7;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        sb.append(c);
                        continue block7;
                    }
                    default: {
                        throw Lang.makeThrow("evalEscape invalid char[%d] '%c'  : %s", i, Character.valueOf(c), str);
                    }
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String[] split(String str, boolean keepQuote, char ... seps) {
        return Strings.split(str, keepQuote, false, seps);
    }

    public static String[] split(String str, boolean keepQuote, boolean keepBlank, char ... seps) {
        LinkedList<String> list = new LinkedList<String>();
        char[] cs = str.toCharArray();
        StringBuilder sb = new StringBuilder();
        block0: for (int i = 0; i < cs.length; ++i) {
            char c = cs[i];
            if (Nums.isin(seps, c)) {
                if (!keepBlank && Strings.isBlank(sb)) continue;
                String s2 = sb.toString();
                if (!keepQuote) {
                    s2 = Strings.evalEscape(s2);
                }
                list.add(s2);
                sb = new StringBuilder();
                continue;
            }
            if (c == '\\') {
                ++i;
                if (keepQuote) {
                    sb.append(c);
                }
                if (i >= cs.length) break;
                c = cs[i];
                sb.append(c);
                continue;
            }
            if (c == '\'' || c == '\"' || c == '`') {
                if (keepQuote) {
                    sb.append(c);
                }
                while (++i < cs.length) {
                    char c2 = cs[i];
                    if (c2 == '\\') {
                        sb.append('\\');
                        if (++i >= cs.length) continue block0;
                        c2 = cs[i];
                        sb.append(c2);
                        continue;
                    }
                    if (c2 == c) {
                        if (!keepQuote) continue block0;
                        sb.append(c2);
                        continue block0;
                    }
                    sb.append(c2);
                }
                continue;
            }
            sb.append(c);
        }
        if (keepBlank || !Strings.isBlank(sb)) {
            String s2 = sb.toString();
            if (!keepQuote) {
                s2 = Strings.evalEscape(s2);
            }
            list.add(s2);
        }
        return list.toArray(new String[list.size()]);
    }

    public static String safeToString(Object obj, String dft) {
        if (obj == null) {
            return "null";
        }
        try {
            return obj.toString();
        }
        catch (Exception exception) {
            if (dft != null) {
                return dft;
            }
            return String.format("/*%s(toString FAILED)*/", obj.getClass().getName());
        }
    }

    public static String unicodeDecode(String s) {
        Matcher m = reUnicode.matcher(s);
        StringBuffer sb = new StringBuffer(s.length());
        while (m.find()) {
            m.appendReplacement(sb, Character.toString((char)Integer.parseInt(m.group(1), 16)));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String cutStr(int length, String s, String supply) {
        if (Lang.isEmpty(length) || Lang.isEmpty(s)) {
            return null;
        }
        if (s.length() <= length) {
            return s;
        }
        return s.substring(0, length - 1) + supply;
    }

    public static boolean isUrl(String s) {
        try {
            new URL(s);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public static boolean isCitizenId(String s) {
        if (Strings.isBlank(s)) {
            return false;
        }
        return Strings.isMactchRegex(P_CitizenId, s);
    }

    public static boolean isMobile(String s) {
        if (Strings.isBlank(s)) {
            return false;
        }
        return Strings.isMactchRegex(P_Mobile, s);
    }

    public static boolean isZipCode(String s) {
        if (Strings.isBlank(s)) {
            return false;
        }
        return Strings.isMactchRegex(P_ZipCode, s);
    }

    public static boolean isMoney(String s) {
        if (Strings.isBlank(s)) {
            return false;
        }
        return Strings.isMactchRegex(P_Money, s);
    }

    public static boolean isNumber(String s) {
        if (Strings.isBlank(s)) {
            return false;
        }
        return Strings.isMactchRegex(P_Number, s);
    }

    public static boolean isMactchRegex(Pattern pattern, String value) {
        return Strings.isMatch(pattern, value);
    }

    public static boolean isMatch(Pattern pattern, String content) {
        if (content == null || pattern == null) {
            return false;
        }
        return pattern.matcher(content).matches();
    }

    public static boolean isEmail(String s) {
        if (Strings.isBlank(s)) {
            return false;
        }
        return Strings.isMatch(P_Email, s);
    }

    public static boolean isQQ(String s) {
        if (Strings.isBlank(s)) {
            return false;
        }
        return Strings.isMatch(P_QQ, s);
    }

    public static boolean isUSCC(String s) {
        if (Strings.isBlank(s)) {
            return false;
        }
        return Strings.isMatch(P_USCC, s);
    }

    public static boolean isUnionPayCard(String s) {
        if (Strings.isBlank(s)) {
            return false;
        }
        return Strings.isMatch(P_UnionPayCard, s);
    }

    public static String removeLast(CharSequence str) {
        if (str == null) {
            return null;
        }
        if (str.length() > 1) {
            return str.subSequence(0, str.length() - 1).toString();
        }
        return "";
    }

    public static String removeLast(String str, char c) {
        return Strings.isEmpty(str) || !str.endsWith(c + "") ? str : str.subSequence(0, str.length() - 1).toString();
    }
}

