/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.json.entity;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nutz.json.Json;
import org.nutz.json.JsonEntityFieldMaker;
import org.nutz.json.JsonFormat;
import org.nutz.json.ToJson;
import org.nutz.json.entity.JsonEntityField;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.born.Borning;
import org.nutz.lang.born.BorningException;

public class JsonEntity {
    private List<JsonEntityField> fields;
    private Map<String, JsonEntityField> fieldMap = new LinkedHashMap<String, JsonEntityField>();
    private Borning<?> borning;
    private BorningException err;
    private Map<String, Integer> typeParams;
    private Method toJsonMethod;
    private JsonEntityFieldMaker fieldMaker = Json.getDefaultFieldMaker();

    public JsonEntity(Mirror<?> mirror) {
        Type type = mirror.getActuallyType();
        this.typeParams = new LinkedHashMap<String, Integer>();
        if (type instanceof ParameterizedType) {
            ParameterizedType pmType = (ParameterizedType)type;
            int i = 0;
            for (Type pmA : pmType.getActualTypeArguments()) {
                this.typeParams.put(pmA.toString(), i++);
            }
        }
        this.fields = this.fieldMaker.make(mirror);
        for (JsonEntityField ef : this.fields) {
            this.fieldMap.put(ef.getName(), ef);
        }
        try {
            this.borning = mirror.getBorning(new Object[0]);
        }
        catch (BorningException e) {
            this.err = e;
        }
        Class<?> klass = mirror.getType();
        ToJson tj = klass.getAnnotation(ToJson.class);
        String myMethodName = Strings.sNull(null == tj ? null : tj.value(), "toJson");
        try {
            try {
                Method myMethod = klass.getMethod(myMethodName, new Class[0]);
                if (!myMethod.isAccessible()) {
                    myMethod.setAccessible(true);
                }
                this.toJsonMethod = myMethod;
            }
            catch (NoSuchMethodException e1) {
                try {
                    Method myMethod = klass.getMethod(myMethodName, JsonFormat.class);
                    if (!myMethod.isAccessible()) {
                        myMethod.setAccessible(true);
                    }
                    this.toJsonMethod = myMethod;
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
        }
        catch (Exception e) {
            throw Lang.wrapThrow(e);
        }
    }

    public List<JsonEntityField> getFields() {
        return this.fields;
    }

    public Object born() {
        if (null == this.borning) {
            throw this.err;
        }
        return this.borning.born(new Object[0]);
    }

    public JsonEntityField getField(String name) {
        return this.fieldMap.get(name);
    }

    public Method getToJsonMethod() {
        return this.toJsonMethod;
    }
}

