/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.loader.json;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.ioc.loader.map.MapLoader;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.resource.NutResource;
import org.nutz.resource.Scans;

public class JsonLoader
extends MapLoader {
    private static final Log log = Logs.get();
    protected String[] paths;

    protected JsonLoader() {
    }

    public JsonLoader(Reader reader) {
        this.loadFromReader(reader);
        if (log.isDebugEnabled()) {
            log.debugf("Loaded %d bean define from reader --\n%s", this.getMap().size(), this.getMap().keySet());
        }
    }

    public JsonLoader(String ... paths) {
        this.setMap(new HashMap<String, Map<String, Object>>());
        List<NutResource> list = Scans.me().loadResource("^(.+[.])(js|json)$", paths);
        try {
            for (NutResource nr : list) {
                if (log.isDebugEnabled()) {
                    log.debugf("loading [%s]", nr.getName());
                }
                this.loadFromReader(nr.getReader());
            }
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        if (log.isDebugEnabled()) {
            log.debugf("Loaded %d bean define from path=%s --> %s", this.getMap().size(), Arrays.toString(paths), this.getMap().keySet());
        }
        this.paths = paths;
    }

    private void loadFromReader(Reader reader) {
        String s = Lang.readAll(reader);
        Map map = (Map)Json.fromJson(s);
        if (null != map && map.size() > 0) {
            this.getMap().putAll(map);
        }
    }

    @Override
    public String toString() {
        if (this.paths == null) {
            return super.toString();
        }
        return "/*" + this.getClass().getSimpleName() + Arrays.toString(this.paths) + "*/\n" + Json.toJson(this.map);
    }

    public String[] getPaths() {
        return this.paths;
    }
}

