/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.java;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.nutz.ioc.IocMaking;
import org.nutz.ioc.java.ChainNode;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;

public class StaticFunctionNode
extends ChainNode {
    private Method method;
    private ChainNode[] args;
    private Field field;

    public StaticFunctionNode(String className, String name, ChainNode[] args) {
        block12: {
            try {
                Mirror<Class<?>> mirror = Mirror.me(Lang.loadClass(className));
                if (null == args || args.length == 0) {
                    try {
                        this.method = mirror.getGetter(name);
                        if (!Modifier.isStatic(this.method.getModifiers())) {
                            throw Lang.makeThrow("Method '%s' of '%s' must be static", name, mirror);
                        }
                        break block12;
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            this.field = mirror.getField(name);
                            if (!Modifier.isStatic(this.field.getModifiers())) {
                                throw Lang.makeThrow("Field '%s' of '%s' must be static", name, mirror);
                            }
                            return;
                        }
                        catch (NoSuchFieldException e1) {
                            throw Lang.makeThrow("Method or field '%s' don't find in '%s'", name, mirror);
                        }
                    }
                }
                Method[] ms = mirror.findMethods(name, args.length);
                if (0 != ms.length) {
                    for (int i = 0; i < ms.length; ++i) {
                        if (!Modifier.isStatic(ms[i].getModifiers())) continue;
                        this.method = ms[i];
                        break;
                    }
                }
                if (this.method == null) {
                    throw Lang.makeThrow("Method '%s' don't find in '%s' or it is NOT static", name, mirror);
                }
                this.args = args;
            }
            catch (ClassNotFoundException e) {
                throw Lang.wrapThrow(e);
            }
        }
    }

    @Override
    protected Object getValue(IocMaking ing, Object obj) throws Exception {
        if (this.method != null) {
            if (null == this.args || this.args.length == 0) {
                return this.method.invoke(obj, new Object[0]);
            }
            Object[] fas = new Object[this.args.length];
            for (int i = 0; i < this.args.length; ++i) {
                fas[i] = this.args[i].getValue(ing, null);
            }
            return this.method.invoke(obj, fas);
        }
        return this.field.get(null);
    }

    @Override
    protected String asString() {
        StringBuilder sb = new StringBuilder();
        if (null != this.args && this.args.length > 0) {
            sb.append(this.args[0].toString());
            for (int i = 1; i < this.args.length; ++i) {
                sb.append(", ").append(this.args[i].toString());
            }
        }
        if (this.method != null) {
            return String.format("%s.%s(%s)", this.method.getDeclaringClass().getName(), this.method.getName(), sb);
        }
        return String.format("%s.%s(%s)", this.field.getDeclaringClass().getName(), this.field.getName(), sb);
    }
}

