/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.jdbc;

import java.io.File;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.nutz.dao.impl.jdbc.AbstractFileValueAdaptor;
import org.nutz.dao.util.blob.SimpleClob;
import org.nutz.filepool.FilePool;
import org.nutz.lang.Streams;

public class ClobValueAdaptor
extends AbstractFileValueAdaptor {
    public ClobValueAdaptor(FilePool pool) {
        super(pool);
        this.suffix = ".clob";
    }

    @Override
    public Object get(ResultSet rs, String colName) throws SQLException {
        Clob clob = rs.getClob(colName);
        if (clob == null) {
            return null;
        }
        File f = this.createTempFile();
        Streams.writeAndClose(Streams.fileOutw(f), clob.getCharacterStream());
        return new SimpleClob(f);
    }

    @Override
    public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
        if (null == obj) {
            stat.setNull(i, 2005);
        } else {
            Clob clob = (Clob)obj;
            stat.setClob(i, clob);
        }
    }
}

