/*
 * Decompiled with CFR 0.152.
 */
package jodd.cache;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class TypeCache<T> {
    private final Map<Class<?>, T> map;

    public static <A> Builder<A> create() {
        return new Builder();
    }

    public static <A> TypeCache<A> createDefault() {
        return Defaults.implementation.get();
    }

    private TypeCache(Map<Class<?>, T> backedMap) {
        this.map = backedMap;
    }

    public T put(Class<?> type, T value) {
        return this.map.put(type, value);
    }

    public T get(Class<?> key) {
        return this.map.get(key);
    }

    public T get(Class<?> key, Supplier<T> valueSupplier) {
        return (T)this.map.computeIfAbsent(key, aClass -> valueSupplier.get());
    }

    public T remove(Class<?> type) {
        return this.map.remove(type);
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void forEachValue(Consumer<? super T> valueConsumer) {
        this.map.values().forEach(valueConsumer);
    }

    public static class Builder<A> {
        private boolean threadsafe;
        private boolean weak;
        private boolean none;

        public Builder<A> noCache() {
            this.none = true;
            return this;
        }

        public Builder<A> weak(boolean weak) {
            this.weak = weak;
            return this;
        }

        public Builder<A> threadsafe(boolean threadsafe) {
            this.threadsafe = threadsafe;
            return this;
        }

        public TypeCache<A> get() {
            Map<Class<Object>, Object> map = this.none ? new AbstractMap<Class<?>, A>(){

                @Override
                public A put(Class<?> key, A value) {
                    return null;
                }

                @Override
                public A get(Object key) {
                    return null;
                }

                @Override
                public Set<Map.Entry<Class<?>, A>> entrySet() {
                    return Collections.emptySet();
                }
            } : (this.weak ? (this.threadsafe ? Collections.synchronizedMap(new WeakHashMap()) : new WeakHashMap()) : (this.threadsafe ? new ConcurrentHashMap() : new IdentityHashMap()));
            return new TypeCache(map);
        }
    }

    public static class Defaults {
        public static Supplier<TypeCache> implementation = () -> TypeCache.create().get();
    }
}

