/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.LangUtils;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class TimeValue {
    static final int INT_UNDEFINED = -1;
    public static final TimeValue NEG_ONE_MILLISECONDS = TimeValue.of(-1L, TimeUnit.MILLISECONDS);
    public static final TimeValue NEG_ONE_SECONDS = TimeValue.of(-1L, TimeUnit.SECONDS);
    public static final TimeValue ZERO_MILLISECONDS = TimeValue.of(0L, TimeUnit.MILLISECONDS);
    private final long duration;
    private final TimeUnit timeUnit;

    public static int asBoundInt(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    public static <T extends TimeValue> T defaultsTo(T timeValue, T defaultValue) {
        return timeValue != null ? timeValue : defaultValue;
    }

    public static TimeValue defaultsToNegativeOneMillisecond(TimeValue timeValue) {
        return TimeValue.defaultsTo(timeValue, NEG_ONE_MILLISECONDS);
    }

    public static TimeValue defaultsToNegativeOneSecond(TimeValue timeValue) {
        return TimeValue.defaultsTo(timeValue, NEG_ONE_SECONDS);
    }

    public static TimeValue defaultsToZeroMillis(TimeValue timeValue) {
        return TimeValue.defaultsTo(timeValue, ZERO_MILLISECONDS);
    }

    public static boolean isNonNegative(TimeValue timeValue) {
        return timeValue != null && timeValue.getDuration() >= 0L;
    }

    public static boolean isPositive(TimeValue timeValue) {
        return timeValue != null && timeValue.getDuration() > 0L;
    }

    public static TimeValue of(long duration, TimeUnit timeUnit) {
        return new TimeValue(duration, timeUnit);
    }

    public static TimeValue ofDays(long days) {
        return TimeValue.of(days, TimeUnit.DAYS);
    }

    public static TimeValue ofHours(long hours) {
        return TimeValue.of(hours, TimeUnit.HOURS);
    }

    public static TimeValue ofMicroseconds(long microseconds) {
        return TimeValue.of(microseconds, TimeUnit.MICROSECONDS);
    }

    public static TimeValue ofMillis(long millis) {
        return TimeValue.of(millis, TimeUnit.MILLISECONDS);
    }

    public static TimeValue ofMinutes(long minutes) {
        return TimeValue.of(minutes, TimeUnit.MINUTES);
    }

    public static TimeValue ofNanoseconds(long nanoseconds) {
        return TimeValue.of(nanoseconds, TimeUnit.NANOSECONDS);
    }

    public static TimeValue ofSeconds(long seconds) {
        return TimeValue.of(seconds, TimeUnit.SECONDS);
    }

    public static TimeValue parse(String value) throws ParseException {
        String[] split = value.split("\\s+");
        if (split.length < 2) {
            throw new IllegalArgumentException(String.format("Expected format for <Integer><SPACE><TimeUnit>: ", value));
        }
        return TimeValue.of(NumberFormat.getInstance(Locale.ROOT).parse(split[0]).longValue(), TimeUnit.valueOf(split[1].trim().toUpperCase(Locale.ROOT)));
    }

    public static long calculateDeadline(long currentTimeMillis, TimeValue timeValue) {
        if (TimeValue.isPositive(timeValue)) {
            long deadline = currentTimeMillis + timeValue.toMillis();
            return deadline >= 0L ? deadline : Long.MAX_VALUE;
        }
        return Long.MAX_VALUE;
    }

    TimeValue(long duration, TimeUnit timeUnit) {
        this.duration = duration;
        this.timeUnit = Args.notNull(timeUnit, "timeUnit");
    }

    public long convert(TimeUnit sourceUnit) {
        return this.timeUnit.convert(this.duration, sourceUnit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TimeValue) {
            TimeValue that = (TimeValue)obj;
            return this.duration == that.duration && LangUtils.equals((Object)this.timeUnit, (Object)that.timeUnit);
        }
        return false;
    }

    public long getDuration() {
        return this.duration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.duration);
        hash = LangUtils.hashCode(hash, (Object)this.timeUnit);
        return hash;
    }

    public void sleep() throws InterruptedException {
        this.timeUnit.sleep(this.duration);
    }

    public void timedJoin(Thread thread) throws InterruptedException {
        this.timeUnit.timedJoin(thread, this.duration);
    }

    public void timedWait(Object obj) throws InterruptedException {
        this.timeUnit.timedWait(obj, this.duration);
    }

    public long toDays() {
        return this.timeUnit.toDays(this.duration);
    }

    public long toHours() {
        return this.timeUnit.toHours(this.duration);
    }

    public long toMicros() {
        return this.timeUnit.toMicros(this.duration);
    }

    public long toMillis() {
        return this.timeUnit.toMillis(this.duration);
    }

    public int toMillisIntBound() {
        return TimeValue.asBoundInt(this.toMillis());
    }

    public long toMinutes() {
        return this.timeUnit.toMinutes(this.duration);
    }

    public long toNanos() {
        return this.timeUnit.toNanos(this.duration);
    }

    public long toSeconds() {
        return this.timeUnit.toSeconds(this.duration);
    }

    public int toSecondsIntBound() {
        return TimeValue.asBoundInt(this.toSeconds());
    }

    public String toString() {
        return String.format(Locale.ROOT, "%,d %s", new Object[]{this.duration, this.timeUnit});
    }

    public Timeout toTimeout() {
        return Timeout.of(this.duration, this.timeUnit);
    }
}

