/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hc.core5.reactor.SingleCoreIOReactor;

final class IOWorkers {
    IOWorkers() {
    }

    static Selector newSelector(SingleCoreIOReactor[] dispatchers) {
        return IOWorkers.isPowerOfTwo(dispatchers.length) ? new PowerOfTwoSelector(dispatchers) : new GenericSelector(dispatchers);
    }

    private static boolean isPowerOfTwo(int val) {
        return (val & -val) == val;
    }

    private static final class GenericSelector
    implements Selector {
        private final AtomicInteger idx = new AtomicInteger(0);
        private final SingleCoreIOReactor[] dispatchers;

        GenericSelector(SingleCoreIOReactor[] dispatchers) {
            this.dispatchers = dispatchers;
        }

        @Override
        public SingleCoreIOReactor next() {
            return this.dispatchers[this.idx.getAndIncrement() % this.dispatchers.length];
        }
    }

    private static final class PowerOfTwoSelector
    implements Selector {
        private final AtomicInteger idx = new AtomicInteger(0);
        private final SingleCoreIOReactor[] dispatchers;

        PowerOfTwoSelector(SingleCoreIOReactor[] dispatchers) {
            this.dispatchers = dispatchers;
        }

        @Override
        public SingleCoreIOReactor next() {
            return this.dispatchers[this.idx.getAndIncrement() & this.dispatchers.length - 1];
        }
    }

    static interface Selector {
        public SingleCoreIOReactor next();
    }
}

