/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio.bootstrap;

import java.util.ArrayList;
import java.util.List;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.impl.DefaultAddressResolver;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.RequestHandlerRegistry;
import org.apache.hc.core5.http.protocol.UriPatternType;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.impl.Http2Processors;
import org.apache.hc.core5.http2.impl.nio.ClientHttp2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.impl.nio.Http2OnlyClientProtocolNegotiator;
import org.apache.hc.core5.http2.impl.nio.Http2StreamListener;
import org.apache.hc.core5.http2.impl.nio.bootstrap.HandlerEntry;
import org.apache.hc.core5.http2.impl.nio.bootstrap.Http2MultiplexingRequester;
import org.apache.hc.core5.http2.nio.support.DefaultAsyncPushConsumerFactory;
import org.apache.hc.core5.http2.ssl.H2ClientTlsStrategy;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.util.Args;

public class Http2MultiplexingRequesterBootstrap {
    private final List<HandlerEntry<Supplier<AsyncPushConsumer>>> pushConsumerList = new ArrayList<HandlerEntry<Supplier<AsyncPushConsumer>>>();
    private UriPatternType uriPatternType;
    private IOReactorConfig ioReactorConfig;
    private HttpProcessor httpProcessor;
    private CharCodingConfig charCodingConfig;
    private H2Config h2Config;
    private TlsStrategy tlsStrategy;
    private boolean strictALPNHandshake;
    private Decorator<IOSession> ioSessionDecorator;
    private IOSessionListener sessionListener;
    private Http2StreamListener streamListener;

    private Http2MultiplexingRequesterBootstrap() {
    }

    public static Http2MultiplexingRequesterBootstrap bootstrap() {
        return new Http2MultiplexingRequesterBootstrap();
    }

    public final Http2MultiplexingRequesterBootstrap setIOReactorConfig(IOReactorConfig ioReactorConfig) {
        this.ioReactorConfig = ioReactorConfig;
        return this;
    }

    public final Http2MultiplexingRequesterBootstrap setHttpProcessor(HttpProcessor httpProcessor) {
        this.httpProcessor = httpProcessor;
        return this;
    }

    public final Http2MultiplexingRequesterBootstrap setH2Config(H2Config h2Config) {
        this.h2Config = h2Config;
        return this;
    }

    public final Http2MultiplexingRequesterBootstrap setCharCodingConfig(CharCodingConfig charCodingConfig) {
        this.charCodingConfig = charCodingConfig;
        return this;
    }

    public final Http2MultiplexingRequesterBootstrap setTlsStrategy(TlsStrategy tlsStrategy) {
        this.tlsStrategy = tlsStrategy;
        return this;
    }

    public final Http2MultiplexingRequesterBootstrap setStrictALPNHandshake(boolean strictALPNHandshake) {
        this.strictALPNHandshake = strictALPNHandshake;
        return this;
    }

    public final Http2MultiplexingRequesterBootstrap setIOSessionDecorator(Decorator<IOSession> ioSessionDecorator) {
        this.ioSessionDecorator = ioSessionDecorator;
        return this;
    }

    public final Http2MultiplexingRequesterBootstrap setIOSessionListener(IOSessionListener sessionListener) {
        this.sessionListener = sessionListener;
        return this;
    }

    public final Http2MultiplexingRequesterBootstrap setStreamListener(Http2StreamListener streamListener) {
        this.streamListener = streamListener;
        return this;
    }

    public final Http2MultiplexingRequesterBootstrap setUriPatternType(UriPatternType uriPatternType) {
        this.uriPatternType = uriPatternType;
        return this;
    }

    public final Http2MultiplexingRequesterBootstrap register(String uriPattern, Supplier<AsyncPushConsumer> supplier) {
        Args.notBlank(uriPattern, "URI pattern");
        Args.notNull(supplier, "Supplier");
        this.pushConsumerList.add(new HandlerEntry<Supplier<AsyncPushConsumer>>(null, uriPattern, supplier));
        return this;
    }

    public final Http2MultiplexingRequesterBootstrap registerVirtual(String hostname, String uriPattern, Supplier<AsyncPushConsumer> supplier) {
        Args.notBlank(hostname, "Hostname");
        Args.notBlank(uriPattern, "URI pattern");
        Args.notNull(supplier, "Supplier");
        this.pushConsumerList.add(new HandlerEntry<Supplier<AsyncPushConsumer>>(hostname, uriPattern, supplier));
        return this;
    }

    public Http2MultiplexingRequester create() {
        RequestHandlerRegistry<Supplier<AsyncPushConsumer>> registry = new RequestHandlerRegistry<Supplier<AsyncPushConsumer>>(this.uriPatternType);
        for (HandlerEntry<Supplier<AsyncPushConsumer>> entry : this.pushConsumerList) {
            registry.register(entry.hostname, entry.uriPattern, (Supplier<AsyncPushConsumer>)entry.handler);
        }
        final ClientHttp2StreamMultiplexerFactory http2StreamHandlerFactory = new ClientHttp2StreamMultiplexerFactory(this.httpProcessor != null ? this.httpProcessor : Http2Processors.client(), new DefaultAsyncPushConsumerFactory(registry), this.h2Config != null ? this.h2Config : H2Config.DEFAULT, this.charCodingConfig != null ? this.charCodingConfig : CharCodingConfig.DEFAULT, this.streamListener);
        return new Http2MultiplexingRequester(this.ioReactorConfig, new IOEventHandlerFactory(){

            @Override
            public IOEventHandler createHandler(ProtocolIOSession ioSession, Object attachment) {
                return new Http2OnlyClientProtocolNegotiator(ioSession, http2StreamHandlerFactory, Http2MultiplexingRequesterBootstrap.this.strictALPNHandshake);
            }
        }, this.ioSessionDecorator, this.sessionListener, DefaultAddressResolver.INSTANCE, this.tlsStrategy != null ? this.tlsStrategy : new H2ClientTlsStrategy());
    }
}

