/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.http2.impl.nio.AbstractHttp2StreamMultiplexer;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Args;

class AbstractHttp2IOEventHandler
implements HttpConnectionEventHandler {
    private final AbstractHttp2StreamMultiplexer streamMultiplexer;

    AbstractHttp2IOEventHandler(AbstractHttp2StreamMultiplexer streamMultiplexer) {
        this.streamMultiplexer = Args.notNull(streamMultiplexer, "Stream multiplexer");
    }

    @Override
    public void connected(IOSession session) throws IOException {
        try {
            this.streamMultiplexer.onConnect(null);
        }
        catch (HttpException ex) {
            this.streamMultiplexer.onException(ex);
        }
    }

    @Override
    public void inputReady(IOSession session) throws IOException {
        try {
            this.streamMultiplexer.onInput();
        }
        catch (HttpException ex) {
            this.streamMultiplexer.onException(ex);
        }
    }

    @Override
    public void outputReady(IOSession session) throws IOException {
        try {
            this.streamMultiplexer.onOutput();
        }
        catch (HttpException ex) {
            this.streamMultiplexer.onException(ex);
        }
    }

    @Override
    public void timeout(IOSession session, int timeoutMillis) throws IOException {
        try {
            this.streamMultiplexer.onTimeout(timeoutMillis);
        }
        catch (HttpException ex) {
            this.streamMultiplexer.onException(ex);
        }
    }

    @Override
    public void exception(IOSession session, Exception cause) {
        this.streamMultiplexer.onException(cause);
    }

    @Override
    public void disconnected(IOSession session) {
        this.streamMultiplexer.onDisconnect();
    }

    @Override
    public void close() throws IOException {
        this.streamMultiplexer.close();
    }

    @Override
    public void close(CloseMode closeMode) {
        this.streamMultiplexer.close(closeMode);
    }

    @Override
    public boolean isOpen() {
        return this.streamMultiplexer.isOpen();
    }

    @Override
    public void setSocketTimeoutMillis(int timeout) {
        this.streamMultiplexer.setSocketTimeoutMillis(timeout);
    }

    @Override
    public SSLSession getSSLSession() {
        return this.streamMultiplexer.getSSLSession();
    }

    @Override
    public EndpointDetails getEndpointDetails() {
        return this.streamMultiplexer.getEndpointDetails();
    }

    @Override
    public int getSocketTimeoutMillis() {
        return this.streamMultiplexer.getSocketTimeoutMillis();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.streamMultiplexer.getProtocolVersion();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.streamMultiplexer.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.streamMultiplexer.getLocalAddress();
    }

    public String toString() {
        return this.streamMultiplexer.toString();
    }
}

