/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.config;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class H2Config {
    public static final H2Config DEFAULT = new Builder().build();
    private final int headerTableSize;
    private final boolean pushEnabled;
    private final int maxConcurrentStreams;
    private final int initialWindowSize;
    private final int maxFrameSize;
    private final int maxHeaderListSize;

    H2Config(int headerTableSize, boolean pushEnabled, int maxConcurrentStreams, int initialWindowSize, int maxFrameSize, int maxHeaderListSize) {
        this.headerTableSize = headerTableSize;
        this.pushEnabled = pushEnabled;
        this.maxConcurrentStreams = maxConcurrentStreams;
        this.initialWindowSize = initialWindowSize;
        this.maxFrameSize = maxFrameSize;
        this.maxHeaderListSize = maxHeaderListSize;
    }

    public int getHeaderTableSize() {
        return this.headerTableSize;
    }

    public boolean isPushEnabled() {
        return this.pushEnabled;
    }

    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public int getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[headerTableSize=").append(this.headerTableSize).append(", pushEnabled=").append(this.pushEnabled).append(", maxConcurrentStreams=").append(this.maxConcurrentStreams).append(", initialWindowSize=").append(this.initialWindowSize).append(", maxFrameSize=").append(this.maxFrameSize).append(", maxHeaderListSize=").append(this.maxHeaderListSize).append("]");
        return builder.toString();
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder copy(H2Config config) {
        Args.notNull(config, "Connection config");
        return new Builder().setHeaderTableSize(config.getHeaderTableSize()).setPushEnabled(config.isPushEnabled()).setMaxConcurrentStreams(config.getMaxConcurrentStreams()).setInitialWindowSize(config.getInitialWindowSize()).setMaxFrameSize(config.getMaxFrameSize()).setMaxHeaderListSize(config.getMaxHeaderListSize());
    }

    public static class Builder {
        private int headerTableSize = 8192;
        private boolean pushEnabled = false;
        private int maxConcurrentStreams = 100;
        private int initialWindowSize = 65535;
        private int maxFrameSize = 65536;
        private int maxHeaderListSize = 0xFFFFFF;

        Builder() {
        }

        public Builder setHeaderTableSize(int headerTableSize) {
            Args.notNegative(headerTableSize, "Header table size");
            this.headerTableSize = headerTableSize;
            return this;
        }

        public Builder setPushEnabled(boolean pushEnabled) {
            this.pushEnabled = pushEnabled;
            return this;
        }

        public Builder setMaxConcurrentStreams(int maxConcurrentStreams) {
            Args.positive(maxConcurrentStreams, "Max concurrent streams");
            this.maxConcurrentStreams = maxConcurrentStreams;
            return this;
        }

        public Builder setInitialWindowSize(int initialWindowSize) {
            Args.positive(initialWindowSize, "Initial window size");
            this.initialWindowSize = initialWindowSize;
            return this;
        }

        public Builder setMaxFrameSize(int maxFrameSize) {
            this.maxFrameSize = Args.checkRange(maxFrameSize, 16384, 0xFFFFFF, "Invalid max frame size");
            return this;
        }

        public Builder setMaxHeaderListSize(int maxHeaderListSize) {
            Args.positive(maxHeaderListSize, "Max header list size");
            this.maxHeaderListSize = maxHeaderListSize;
            return this;
        }

        public H2Config build() {
            return new H2Config(this.headerTableSize, this.pushEnabled, this.maxConcurrentStreams, this.initialWindowSize, this.maxFrameSize, this.maxHeaderListSize);
        }
    }
}

