/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

public class BasicResponseConsumer<T>
implements AsyncResponseConsumer<Message<HttpResponse, T>> {
    private final AsyncEntityConsumer<T> dataConsumer;
    private volatile Message<HttpResponse, T> result;

    public BasicResponseConsumer(AsyncEntityConsumer<T> dataConsumer) {
        this.dataConsumer = Args.notNull(dataConsumer, "Consumer");
    }

    @Override
    public void consumeResponse(final HttpResponse response, EntityDetails entityDetails, HttpContext httpContext, final FutureCallback<Message<HttpResponse, T>> resultCallback) throws HttpException, IOException {
        Args.notNull(response, "Response");
        if (entityDetails != null) {
            this.dataConsumer.streamStart(entityDetails, new FutureCallback<T>(){

                @Override
                public void completed(T body) {
                    BasicResponseConsumer.this.result = new Message(response, body);
                    if (resultCallback != null) {
                        resultCallback.completed(BasicResponseConsumer.this.result);
                    }
                    BasicResponseConsumer.this.dataConsumer.releaseResources();
                }

                @Override
                public void failed(Exception ex) {
                    if (resultCallback != null) {
                        resultCallback.failed(ex);
                    }
                }

                @Override
                public void cancelled() {
                    if (resultCallback != null) {
                        resultCallback.cancelled();
                    }
                }
            });
        } else {
            this.result = new Message<HttpResponse, Object>(response, null);
            if (resultCallback != null) {
                resultCallback.completed(this.result);
            }
            this.dataConsumer.releaseResources();
        }
    }

    @Override
    public void informationResponse(HttpResponse response, HttpContext httpContext) throws HttpException, IOException {
    }

    @Override
    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.dataConsumer.updateCapacity(capacityChannel);
    }

    @Override
    public int consume(ByteBuffer src) throws IOException {
        return this.dataConsumer.consume(src);
    }

    @Override
    public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        this.dataConsumer.streamEnd(trailers);
    }

    @Override
    public void failed(Exception cause) {
        this.releaseResources();
    }

    @Override
    public Message<HttpResponse, T> getResult() {
        return this.result;
    }

    @Override
    public void releaseResources() {
        this.dataConsumer.releaseResources();
    }
}

