/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.List;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.net.URLEncodedUtils;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.apache.hc.core5.util.CharArrayBuffer;

public final class EntityUtils {
    private EntityUtils() {
    }

    public static void consumeQuietly(HttpEntity entity) {
        try {
            EntityUtils.consume(entity);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void consume(HttpEntity entity) throws IOException {
        InputStream inStream;
        if (entity == null) {
            return;
        }
        if (entity.isStreaming() && (inStream = entity.getContent()) != null) {
            inStream.close();
        }
    }

    public static void updateEntity(ClassicHttpResponse response, HttpEntity entity) throws IOException {
        Args.notNull(response, "Response");
        EntityUtils.consume(response.getEntity());
        response.setEntity(entity);
    }

    public static ContentType getContentType(HttpEntity entity) throws UnsupportedCharsetException {
        if (entity == null) {
            return null;
        }
        String contentType = entity.getContentType();
        if (contentType != null) {
            return ContentType.parse(contentType);
        }
        return null;
    }

    public static ContentType getContentTypeLenient(HttpEntity entity) {
        if (entity == null) {
            return null;
        }
        String contentType = entity.getContentType();
        if (contentType != null) {
            return ContentType.parseLenient(contentType);
        }
        return null;
    }

    public static ContentType getContentTypeOrDefault(HttpEntity entity) throws UnsupportedCharsetException {
        ContentType contentType = EntityUtils.getContentType(entity);
        return contentType != null ? contentType : ContentType.DEFAULT_TEXT;
    }

    public static ContentType getContentTypeLenientOrDefault(HttpEntity entity) throws UnsupportedCharsetException {
        ContentType contentType = EntityUtils.getContentType(entity);
        return contentType != null ? contentType : ContentType.DEFAULT_TEXT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(HttpEntity entity) throws IOException {
        Args.notNull(entity, "Entity");
        InputStream inStream = entity.getContent();
        if (inStream == null) {
            return null;
        }
        try {
            int l;
            int i = (int)Args.checkContentLength(entity);
            if (i < 0) {
                i = 4096;
            }
            ByteArrayBuffer buffer = new ByteArrayBuffer(i);
            byte[] tmp = new byte[4096];
            while ((l = inStream.read(tmp)) != -1) {
                buffer.append(tmp, 0, l);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        finally {
            inStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toString(HttpEntity entity, ContentType contentType) throws IOException {
        InputStream inStream = entity.getContent();
        if (inStream == null) {
            return null;
        }
        try {
            int chReadCount;
            int contentLength = (int)Args.checkContentLength(entity);
            if (contentLength < 0) {
                contentLength = 4096;
            }
            Charset charset = null;
            if (contentType != null && (charset = contentType.getCharset()) == null) {
                ContentType defaultContentType = ContentType.getByMimeType(contentType.getMimeType());
                Charset charset2 = charset = defaultContentType != null ? defaultContentType.getCharset() : null;
            }
            if (charset == null) {
                charset = StandardCharsets.ISO_8859_1;
            }
            InputStreamReader reader = new InputStreamReader(inStream, charset);
            CharArrayBuffer buffer = new CharArrayBuffer(contentLength);
            char[] tmp = new char[1024];
            while ((chReadCount = reader.read(tmp)) != -1) {
                buffer.append(tmp, 0, chReadCount);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            inStream.close();
        }
    }

    public static String toString(HttpEntity entity, Charset defaultCharset) throws IOException, ParseException {
        ContentType contentType;
        block5: {
            Args.notNull(entity, "Entity");
            contentType = null;
            try {
                contentType = EntityUtils.getContentType(entity);
            }
            catch (UnsupportedCharsetException ex) {
                if (defaultCharset != null) break block5;
                throw new UnsupportedEncodingException(ex.getMessage());
            }
        }
        if (contentType != null) {
            if (contentType.getCharset() == null) {
                contentType = contentType.withCharset(defaultCharset);
            }
        } else {
            contentType = ContentType.DEFAULT_TEXT.withCharset(defaultCharset);
        }
        return EntityUtils.toString(entity, contentType);
    }

    public static String toString(HttpEntity entity, String defaultCharset) throws IOException, ParseException {
        return EntityUtils.toString(entity, defaultCharset != null ? Charset.forName(defaultCharset) : null);
    }

    public static String toString(HttpEntity entity) throws IOException, ParseException {
        Args.notNull(entity, "Entity");
        return EntityUtils.toString(entity, EntityUtils.getContentType(entity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<NameValuePair> parse(HttpEntity entity) throws IOException {
        CharArrayBuffer buf;
        Args.notNull(entity, "HTTP entity");
        ContentType contentType = EntityUtils.getContentType(entity);
        if (contentType == null || !contentType.getMimeType().equalsIgnoreCase("application/x-www-form-urlencoded")) {
            return Collections.emptyList();
        }
        long len = entity.getContentLength();
        Args.checkRange(len, 0L, Integer.MAX_VALUE, "HTTP entity is too large");
        Charset charset = contentType.getCharset() != null ? contentType.getCharset() : StandardCharsets.ISO_8859_1;
        InputStream inStream = entity.getContent();
        if (inStream == null) {
            return Collections.emptyList();
        }
        try {
            int l;
            buf = new CharArrayBuffer(len > 0L ? (int)len : 1024);
            InputStreamReader reader = new InputStreamReader(inStream, charset);
            char[] tmp = new char[1024];
            while ((l = reader.read(tmp)) != -1) {
                buf.append(tmp, 0, l);
            }
        }
        finally {
            inStream.close();
        }
        if (buf.isEmpty()) {
            return Collections.emptyList();
        }
        return URLEncodedUtils.parse(buf, charset, '&');
    }
}

