/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.impl.nio.ServerHttp1IOEventHandler;
import org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexerFactory;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ServerHttp1IOEventHandlerFactory
implements IOEventHandlerFactory {
    private final ServerHttp1StreamDuplexerFactory streamDuplexerFactory;
    private final TlsStrategy tlsStrategy;

    public ServerHttp1IOEventHandlerFactory(ServerHttp1StreamDuplexerFactory streamDuplexerFactory, TlsStrategy tlsStrategy) {
        this.streamDuplexerFactory = Args.notNull(streamDuplexerFactory, "Stream duplexer factory");
        this.tlsStrategy = tlsStrategy;
    }

    @Override
    public IOEventHandler createHandler(ProtocolIOSession ioSession, Object attachment) {
        boolean tlsSecured = this.tlsStrategy != null ? this.tlsStrategy.upgrade(ioSession, null, ioSession.getLocalAddress(), ioSession.getRemoteAddress(), attachment) : false;
        return new ServerHttp1IOEventHandler(this.streamDuplexerFactory.create(tlsSecured ? URIScheme.HTTPS.id : URIScheme.HTTP.id, ioSession));
    }
}

