/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.UnsupportedHttpVersionException;
import org.apache.hc.core5.http.config.H1Config;
import org.apache.hc.core5.http.impl.nio.Http1StreamChannel;
import org.apache.hc.core5.http.impl.nio.MessageState;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.http.nio.ResourceHolder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;

class ClientHttp1StreamHandler
implements ResourceHolder {
    private final Http1StreamChannel<HttpRequest> outputChannel;
    private final DataStreamChannel internalDataChannel;
    private final HttpProcessor httpProcessor;
    private final H1Config h1Config;
    private final ConnectionReuseStrategy connectionReuseStrategy;
    private final AsyncClientExchangeHandler exchangeHandler;
    private final HttpCoreContext context;
    private final AtomicBoolean requestCommitted;
    private final AtomicBoolean done;
    private volatile boolean keepAlive;
    private volatile int timeout;
    private volatile HttpRequest committedRequest;
    private volatile MessageState requestState;
    private volatile MessageState responseState;

    ClientHttp1StreamHandler(final Http1StreamChannel<HttpRequest> outputChannel, HttpProcessor httpProcessor, H1Config h1Config, ConnectionReuseStrategy connectionReuseStrategy, AsyncClientExchangeHandler exchangeHandler, HttpCoreContext context) {
        this.outputChannel = outputChannel;
        this.internalDataChannel = new DataStreamChannel(){

            @Override
            public void requestOutput() {
                outputChannel.requestOutput();
            }

            @Override
            public void endStream(List<? extends Header> trailers) throws IOException {
                outputChannel.complete(trailers);
                ClientHttp1StreamHandler.this.requestState = MessageState.COMPLETE;
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                return outputChannel.write(src);
            }

            @Override
            public void endStream() throws IOException {
                this.endStream(null);
            }
        };
        this.httpProcessor = httpProcessor;
        this.h1Config = h1Config;
        this.connectionReuseStrategy = connectionReuseStrategy;
        this.exchangeHandler = exchangeHandler;
        this.context = context;
        this.requestCommitted = new AtomicBoolean(false);
        this.done = new AtomicBoolean(false);
        this.keepAlive = true;
        this.requestState = MessageState.IDLE;
        this.responseState = MessageState.HEADERS;
    }

    boolean isResponseFinal() {
        return this.responseState == MessageState.COMPLETE;
    }

    boolean isCompleted() {
        return this.requestState == MessageState.COMPLETE && this.responseState == MessageState.COMPLETE;
    }

    String getRequestMethod() {
        return this.committedRequest != null ? this.committedRequest.getMethod() : null;
    }

    boolean isOutputReady() {
        switch (this.requestState) {
            case IDLE: 
            case ACK: {
                return true;
            }
            case BODY: {
                return this.exchangeHandler.available() > 0;
            }
        }
        return false;
    }

    private void commitRequest(HttpRequest request, EntityDetails entityDetails) throws IOException, HttpException {
        if (this.requestCommitted.compareAndSet(false, true)) {
            ProtocolVersion transportVersion = request.getVersion();
            if (transportVersion != null && transportVersion.greaterEquals(HttpVersion.HTTP_2)) {
                throw new UnsupportedHttpVersionException(transportVersion);
            }
            this.context.setProtocolVersion(transportVersion);
            this.context.setAttribute("http.request", request);
            this.httpProcessor.process(request, entityDetails, (HttpContext)this.context);
            boolean endStream = entityDetails == null;
            this.outputChannel.submit(request, endStream);
            this.committedRequest = request;
            if (endStream) {
                this.requestState = MessageState.COMPLETE;
            } else {
                boolean expectContinue;
                Header h = request.getFirstHeader("Expect");
                boolean bl = expectContinue = h != null && "100-continue".equalsIgnoreCase(h.getValue());
                if (expectContinue) {
                    this.requestState = MessageState.ACK;
                    this.timeout = this.outputChannel.getSocketTimeoutMillis();
                    this.outputChannel.setSocketTimeoutMillis(this.h1Config.getWaitForContinueTimeoutMillis());
                } else {
                    this.requestState = MessageState.BODY;
                    this.exchangeHandler.produce(this.internalDataChannel);
                }
            }
        } else {
            throw new HttpException("Request already committed");
        }
    }

    void produceOutput() throws HttpException, IOException {
        switch (this.requestState) {
            case IDLE: {
                this.requestState = MessageState.HEADERS;
                this.exchangeHandler.produceRequest(new RequestChannel(){

                    @Override
                    public void sendRequest(HttpRequest request, EntityDetails entityDetails, HttpContext httpContext) throws HttpException, IOException {
                        ClientHttp1StreamHandler.this.commitRequest(request, entityDetails);
                    }
                }, this.context);
                break;
            }
            case ACK: {
                this.outputChannel.suspendOutput();
                break;
            }
            case BODY: {
                this.exchangeHandler.produce(this.internalDataChannel);
            }
        }
    }

    void consumeHeader(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
        if (this.done.get() || this.responseState != MessageState.HEADERS) {
            throw new ProtocolException("Unexpected message head");
        }
        ProtocolVersion transportVersion = response.getVersion();
        if (transportVersion != null && transportVersion.greaterEquals(HttpVersion.HTTP_2)) {
            throw new UnsupportedHttpVersionException(transportVersion);
        }
        int status = response.getCode();
        if (status < 100) {
            throw new ProtocolException("Invalid response: " + new StatusLine(response));
        }
        if (status > 100 && status < 200) {
            this.exchangeHandler.consumeInformation(response, this.context);
        } else if (!this.connectionReuseStrategy.keepAlive(this.committedRequest, response, this.context)) {
            this.keepAlive = false;
        }
        if (this.requestState == MessageState.ACK && (status == 100 || status >= 200)) {
            this.outputChannel.setSocketTimeoutMillis(this.timeout);
            this.requestState = MessageState.BODY;
            if (status < 400) {
                this.exchangeHandler.produce(this.internalDataChannel);
            }
        }
        if (status < 200) {
            return;
        }
        if (this.requestState == MessageState.BODY && this.keepAlive && status >= 400) {
            this.requestState = MessageState.COMPLETE;
            if (!this.outputChannel.abortGracefully()) {
                this.keepAlive = false;
            }
        }
        this.context.setAttribute("http.response", response);
        this.httpProcessor.process(response, entityDetails, (HttpContext)this.context);
        this.exchangeHandler.consumeResponse(response, entityDetails, this.context);
        if (entityDetails == null) {
            if (!this.keepAlive) {
                this.outputChannel.close();
            }
            this.responseState = MessageState.COMPLETE;
        } else {
            this.responseState = MessageState.BODY;
        }
    }

    int consumeData(ByteBuffer src) throws HttpException, IOException {
        if (this.done.get() || this.responseState != MessageState.BODY) {
            throw new ProtocolException("Unexpected message data");
        }
        return this.exchangeHandler.consume(src);
    }

    void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.exchangeHandler.updateCapacity(capacityChannel);
    }

    void dataEnd(List<? extends Header> trailers) throws HttpException, IOException {
        if (this.done.get() || this.responseState != MessageState.BODY) {
            throw new ProtocolException("Unexpected message data");
        }
        if (!this.keepAlive) {
            this.outputChannel.close();
        }
        this.responseState = MessageState.COMPLETE;
        this.exchangeHandler.streamEnd(trailers);
    }

    boolean handleTimeout() {
        if (this.requestState == MessageState.ACK) {
            this.requestState = MessageState.BODY;
            this.outputChannel.setSocketTimeoutMillis(this.timeout);
            this.outputChannel.requestOutput();
            return true;
        }
        return false;
    }

    void failed(Exception cause) {
        if (!this.done.get()) {
            this.exchangeHandler.failed(cause);
        }
    }

    @Override
    public void releaseResources() {
        if (this.done.compareAndSet(false, true)) {
            this.responseState = MessageState.COMPLETE;
            this.requestState = MessageState.COMPLETE;
            this.exchangeHandler.releaseResources();
        }
    }

    public String toString() {
        return "[requestState=" + (Object)((Object)this.requestState) + ", responseState=" + (Object)((Object)this.responseState) + ']';
    }
}

