/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequestFactory;
import org.apache.hc.core5.http.config.H1Config;
import org.apache.hc.core5.http.impl.io.AbstractMessageParser;
import org.apache.hc.core5.http.impl.io.DefaultClassicHttpRequestFactory;
import org.apache.hc.core5.http.message.LineParser;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.util.CharArrayBuffer;

public class DefaultHttpRequestParser
extends AbstractMessageParser<ClassicHttpRequest> {
    private final HttpRequestFactory<ClassicHttpRequest> requestFactory;

    public DefaultHttpRequestParser(LineParser lineParser, HttpRequestFactory<ClassicHttpRequest> requestFactory, H1Config h1Config) {
        super(lineParser, h1Config);
        this.requestFactory = requestFactory != null ? requestFactory : DefaultClassicHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParser(H1Config h1Config) {
        this(null, null, h1Config);
    }

    public DefaultHttpRequestParser() {
        this(H1Config.DEFAULT);
    }

    @Override
    protected IOException createConnectionClosedException() {
        return new ConnectionClosedException("Client closed connection");
    }

    @Override
    protected ClassicHttpRequest createMessage(CharArrayBuffer buffer) throws IOException, HttpException {
        RequestLine requestLine = this.getLineParser().parseRequestLine(buffer);
        ClassicHttpRequest request = this.requestFactory.newHttpRequest(requestLine.getMethod(), requestLine.getUri());
        request.setVersion(requestLine.getProtocolVersion());
        return request;
    }
}

