/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.util.Locale;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.Ports;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.LangUtils;
import org.apache.hc.core5.util.TextUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class HttpHost
implements NamedEndpoint,
Serializable {
    private static final long serialVersionUID = -7529410654042457626L;
    public static final URIScheme DEFAULT_SCHEME = URIScheme.HTTP;
    private final String hostname;
    private final String lcHostname;
    private final int port;
    private final String schemeName;
    private final InetAddress address;

    private HttpHost(String hostname, int port, String scheme, boolean internal) {
        this.hostname = hostname;
        this.lcHostname = hostname;
        this.schemeName = scheme;
        this.port = Ports.checkWithDefault(port);
        this.address = null;
    }

    public HttpHost(String hostname, int port, String scheme) {
        this.hostname = Args.containsNoBlanks(hostname, "Host name");
        this.lcHostname = hostname.toLowerCase(Locale.ROOT);
        this.schemeName = scheme != null ? scheme.toLowerCase(Locale.ROOT) : HttpHost.DEFAULT_SCHEME.id;
        this.port = Ports.checkWithDefault(port);
        this.address = null;
    }

    public HttpHost(String hostname, int port) {
        this(hostname, port, null);
    }

    public HttpHost(String hostname, String scheme) {
        this(hostname, -1, scheme);
    }

    public static HttpHost create(String s) throws URISyntaxException {
        Args.notEmpty(s, "HTTP Host");
        String text = s;
        String scheme = null;
        int schemeIdx = text.indexOf("://");
        if (schemeIdx > 0) {
            scheme = text.substring(0, schemeIdx);
            if (TextUtils.containsBlanks(scheme)) {
                throw new URISyntaxException(s, "scheme contains blanks");
            }
            text = text.substring(schemeIdx + 3);
        }
        int port = -1;
        int portIdx = text.lastIndexOf(":");
        if (portIdx > 0) {
            try {
                port = Integer.parseInt(text.substring(portIdx + 1));
            }
            catch (NumberFormatException ex) {
                throw new URISyntaxException(s, "invalid port");
            }
            text = text.substring(0, portIdx);
        }
        if (TextUtils.containsBlanks(text)) {
            throw new URISyntaxException(s, "hostname contains blanks");
        }
        return new HttpHost(text.toLowerCase(Locale.ROOT), port, scheme != null ? scheme.toLowerCase(Locale.ROOT) : HttpHost.DEFAULT_SCHEME.id, true);
    }

    public HttpHost(String hostname) {
        this(hostname, -1, null);
    }

    public HttpHost(InetAddress address, int port, String scheme) {
        this(Args.notNull(address, "Inet address"), address.getHostName(), port, scheme);
    }

    public HttpHost(InetAddress address, String hostname, int port, String scheme) {
        this.address = Args.notNull(address, "Inet address");
        this.hostname = Args.notNull(hostname, "Hostname");
        this.lcHostname = this.hostname.toLowerCase(Locale.ROOT);
        this.schemeName = scheme != null ? scheme.toLowerCase(Locale.ROOT) : HttpHost.DEFAULT_SCHEME.id;
        this.port = Ports.checkWithDefault(port);
    }

    public HttpHost(InetAddress address, int port) {
        this(address, port, null);
    }

    public HttpHost(InetAddress address) {
        this(address, -1, null);
    }

    public HttpHost(NamedEndpoint namedEndpoint, String scheme) {
        this(namedEndpoint.getHostName(), namedEndpoint.getPort(), scheme);
    }

    public HttpHost(URIAuthority authority) {
        this(authority, null);
    }

    @Override
    public String getHostName() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String toURI() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.schemeName);
        buffer.append("://");
        buffer.append(this.hostname);
        if (this.port != -1) {
            buffer.append(':');
            buffer.append(Integer.toString(this.port));
        }
        return buffer.toString();
    }

    public String toHostString() {
        if (this.port != -1) {
            StringBuilder buffer = new StringBuilder(this.hostname.length() + 6);
            buffer.append(this.hostname);
            buffer.append(":");
            buffer.append(Integer.toString(this.port));
            return buffer.toString();
        }
        return this.hostname;
    }

    public String toString() {
        return this.toURI();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HttpHost) {
            HttpHost that = (HttpHost)obj;
            return this.lcHostname.equals(that.lcHostname) && this.port == that.port && this.schemeName.equals(that.schemeName) && LangUtils.equals(this.address, that.address);
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.lcHostname);
        hash = LangUtils.hashCode(hash, this.port);
        hash = LangUtils.hashCode(hash, this.schemeName);
        hash = LangUtils.hashCode(hash, this.address);
        return hash;
    }
}

