/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.thread.GlobalThreadPool;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadUtil {
    private ThreadUtil() {
    }

    public static ExecutorService newExecutor(int threadSize) {
        return Executors.newFixedThreadPool(threadSize);
    }

    public static ExecutorService newExecutor() {
        return Executors.newCachedThreadPool();
    }

    public static ExecutorService newSingleExecutor() {
        return Executors.newSingleThreadExecutor();
    }

    public static ThreadPoolExecutor newExecutor(int corePoolSize, int maximumPoolSize) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static ThreadPoolExecutor newExecutorByBlockingCoefficient(float blockingCoefficient) {
        if (blockingCoefficient > 1.0f || blockingCoefficient <= 0.0f) {
            throw new IllegalArgumentException("[blockingCoefficient] must between 0 and 1, or equals 0.");
        }
        int poolSize = (int)((float)Runtime.getRuntime().availableProcessors() / (1.0f - blockingCoefficient));
        return new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static void execute(Runnable runnable) {
        GlobalThreadPool.execute(runnable);
    }

    public static Runnable excAsync(final Runnable runnable, boolean isDeamon) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                runnable.run();
            }
        };
        thread.setDaemon(isDeamon);
        thread.start();
        return runnable;
    }

    public static <T> Future<T> execAsync(Callable<T> task) {
        return GlobalThreadPool.submit(task);
    }

    public static Future<?> execAsync(Runnable runnable) {
        return GlobalThreadPool.submit(runnable);
    }

    public static <T> CompletionService<T> newCompletionService() {
        return new ExecutorCompletionService(GlobalThreadPool.getExecutor());
    }

    public static <T> CompletionService<T> newCompletionService(ExecutorService executor) {
        return new ExecutorCompletionService(executor);
    }

    public static CountDownLatch newCountDownLatch(int threadCount) {
        return new CountDownLatch(threadCount);
    }

    public static boolean sleep(Number timeout, TimeUnit timeUnit) {
        try {
            timeUnit.sleep(timeout.longValue());
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public static boolean sleep(Number millis) {
        if (millis == null) {
            return true;
        }
        try {
            Thread.sleep(millis.longValue());
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public static boolean safeSleep(Number millis) {
        long before;
        long after;
        long millisLong = millis.longValue();
        for (long done = 0L; done < millisLong; done += after - before) {
            before = System.currentTimeMillis();
            if (!ThreadUtil.sleep(millisLong - done)) {
                return false;
            }
            after = System.currentTimeMillis();
        }
        return true;
    }

    public static StackTraceElement[] getStackTrace() {
        return Thread.currentThread().getStackTrace();
    }

    public static StackTraceElement getStackTraceElement(int i) {
        StackTraceElement[] stackTrace = ThreadUtil.getStackTrace();
        if (i < 0) {
            i += stackTrace.length;
        }
        return stackTrace[i];
    }

    public static <T> ThreadLocal<T> createThreadLocal(boolean isInheritable) {
        if (isInheritable) {
            return new InheritableThreadLocal();
        }
        return new ThreadLocal();
    }

    public static void interupt(Thread thread, boolean isJoin) {
        if (null != thread && !thread.isInterrupted()) {
            thread.interrupt();
            if (isJoin) {
                ThreadUtil.waitForDie(thread);
            }
        }
    }

    public static void waitForDie(Thread thread) {
        boolean dead = false;
        do {
            try {
                thread.join();
                dead = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!dead);
    }

    public static Thread[] getThreads() {
        return ThreadUtil.getThreads(Thread.currentThread().getThreadGroup().getParent());
    }

    public static Thread[] getThreads(ThreadGroup group) {
        Thread[] slackList = new Thread[group.activeCount() * 2];
        int actualSize = group.enumerate(slackList);
        Thread[] result = new Thread[actualSize];
        System.arraycopy(slackList, 0, result, 0, actualSize);
        return result;
    }

    public static Thread getMainThread() {
        for (Thread thread : ThreadUtil.getThreads()) {
            if (thread.getId() != 1L) continue;
            return thread;
        }
        return null;
    }
}

