/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.io.resource;

import com.xiaoleilu.hutool.io.IORuntimeException;
import com.xiaoleilu.hutool.util.ClassLoaderUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;

public class ResourceUtil {
    public static URL getResource(String resource) throws IORuntimeException {
        return ResourceUtil.getResource(resource, null);
    }

    public static List<URL> getResources(String resource) {
        Enumeration<URL> resources;
        try {
            resources = ClassLoaderUtil.getClassLoader().getResources(resource);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return CollectionUtil.newArrayList(resources);
    }

    public static URL getResource(String resource, Class<?> baseClass) {
        return null != baseClass ? baseClass.getResource(resource) : ClassLoaderUtil.getClassLoader().getResource(resource);
    }
}

