/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.cron.task;

import com.xiaoleilu.hutool.cron.CronException;
import com.xiaoleilu.hutool.cron.task.Task;
import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.util.ClassLoaderUtil;
import com.xiaoleilu.hutool.util.ClassUtil;
import com.xiaoleilu.hutool.util.ReflectUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class InvokeTask
implements Task {
    private Class<?> clazz;
    private Object obj;
    private Method method;

    public InvokeTask(String classNameWithMethodName) {
        int splitIndex = classNameWithMethodName.lastIndexOf(35);
        if (splitIndex <= 0) {
            splitIndex = classNameWithMethodName.lastIndexOf(46);
        }
        if (splitIndex <= 0) {
            throw new UtilException("Invalid classNameWithMethodName [{}]!", classNameWithMethodName);
        }
        String className = classNameWithMethodName.substring(0, splitIndex);
        if (StrUtil.isBlank(className)) {
            throw new IllegalArgumentException("Class name is blank !");
        }
        this.clazz = ClassLoaderUtil.loadClass(className);
        if (null == this.clazz) {
            throw new IllegalArgumentException("Load class with name of [" + className + "] fail !");
        }
        this.obj = ClassUtil.newInstance(this.clazz);
        String methodName = classNameWithMethodName.substring(splitIndex + 1);
        if (StrUtil.isBlank(methodName)) {
            throw new IllegalArgumentException("Method name is blank !");
        }
        this.method = ClassUtil.getPublicMethod(this.clazz, methodName, new Class[0]);
        if (null == this.method) {
            throw new IllegalArgumentException("No method with name of [" + methodName + "] !");
        }
    }

    @Override
    public void execute() {
        try {
            ReflectUtil.invoke(this.obj, this.method, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new CronException(e);
        }
    }
}

