/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.sample.Queue;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.common.ServiceException;
import com.aliyun.mns.common.utils.ServiceSettings;

public class DeleteQueueDemo {
    public static void main(String[] args) {
        CloudAccount account = new CloudAccount(ServiceSettings.getMNSAccessKeyId(), ServiceSettings.getMNSAccessKeySecret(), ServiceSettings.getMNSAccountEndpoint());
        MNSClient client = account.getMNSClient();
        try {
            CloudQueue queue = client.getQueueRef("cloud-queue-demo");
            queue.delete();
            System.out.println("Delete cloud-queue-demo successfully!");
        }
        catch (ClientException ce) {
            System.out.println("Something wrong with the network connection between client and MNS service.Please check your network and DNS availablity.");
            ce.printStackTrace();
        }
        catch (ServiceException se) {
            if (se.getErrorCode().equals("QueueNotExist")) {
                System.out.println("Queue is not exist.Please create before use");
            } else if (se.getErrorCode().equals("TimeExpired")) {
                System.out.println("The request is time expired. Please check your local machine timeclock");
            }
            se.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Unknown exception happened!");
            e.printStackTrace();
        }
        client.close();
    }
}

