/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.listener;

import com.alibaba.nacos.common.util.SystemUtils;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class StartingSpringApplicationRunListener
implements SpringApplicationRunListener,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartingSpringApplicationRunListener.class);
    private static final String MODE_PROPERTY_KEY = "nacos.mode";
    private static final String LOCAL_IP_PROPERTY_KEY = "nacos.local.ip";
    private ScheduledExecutorService scheduledExecutorService;
    private volatile boolean starting;

    public StartingSpringApplicationRunListener(SpringApplication application, String[] args) {
    }

    public void starting() {
        this.starting = true;
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
        if (SystemUtils.STANDALONE_MODE) {
            System.setProperty(MODE_PROPERTY_KEY, "stand alone");
        } else {
            System.setProperty(MODE_PROPERTY_KEY, "cluster");
        }
        System.setProperty(LOCAL_IP_PROPERTY_KEY, SystemUtils.LOCAL_IP);
    }

    public void contextPrepared(ConfigurableApplicationContext context) {
        this.logClusterConf();
        this.logStarting();
    }

    public void contextLoaded(ConfigurableApplicationContext context) {
    }

    public void started(ConfigurableApplicationContext context) {
        this.starting = false;
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
        this.logFilePath();
        LOGGER.info("Nacos started successfully in {} mode.", (Object)System.getProperty(MODE_PROPERTY_KEY));
    }

    public void running(ConfigurableApplicationContext context) {
    }

    public void failed(ConfigurableApplicationContext context, Throwable exception) {
        this.starting = false;
        this.logFilePath();
        LOGGER.error("Nacos failed to start, please see {}/logs/nacos.log for more details.", (Object)SystemUtils.NACOS_HOME);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    private void logClusterConf() {
        if (!SystemUtils.STANDALONE_MODE) {
            try {
                List clusterConf = SystemUtils.readClusterConf();
                LOGGER.info("The server IP list of Nacos is {}", (Object)clusterConf);
            }
            catch (IOException e) {
                LOGGER.error("read cluster conf fail", (Throwable)e);
            }
        }
    }

    private void logFilePath() {
        LOGGER.info("Nacos Log files: {}/logs/", (Object)SystemUtils.NACOS_HOME);
        LOGGER.info("Nacos Conf files: {}/conf/", (Object)SystemUtils.NACOS_HOME);
        LOGGER.info("Nacos Data files: {}/data/", (Object)SystemUtils.NACOS_HOME);
    }

    private void logStarting() {
        if (!SystemUtils.STANDALONE_MODE) {
            this.scheduledExecutorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r, "nacos-starting");
                    thread.setDaemon(true);
                    return thread;
                }
            });
            this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (StartingSpringApplicationRunListener.this.starting) {
                        LOGGER.info("Nacos is starting...");
                    }
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }
    }
}

