/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemConfig {
    public static final String LOCAL_IP = SystemConfig.getHostAddress();
    private static final Logger log = LoggerFactory.getLogger(SystemConfig.class);

    private static String getHostAddress() {
        String address = System.getProperty("nacos.server.ip");
        if (StringUtils.isNotEmpty((CharSequence)address)) {
            return address;
        }
        address = "127.0.0.1";
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface ni = en.nextElement();
                Enumeration<InetAddress> ads = ni.getInetAddresses();
                while (ads.hasMoreElements()) {
                    InetAddress ip = ads.nextElement();
                    if (ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            log.error("get local host address error", (Throwable)e);
        }
        return address;
    }
}

