/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SimpleIPFlowData {
    private AtomicInteger[] data;
    private int slotCount;
    private int averageCount;
    private ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("nacos ip flow control thread");
            t.setDaemon(true);
            return t;
        }
    });

    public SimpleIPFlowData(int slotCount, int interval) {
        this.slotCount = slotCount <= 0 ? 1 : slotCount;
        this.data = new AtomicInteger[slotCount];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new AtomicInteger(0);
        }
        this.timer.scheduleAtFixedRate(new DefaultIPFlowDataManagerTask(), interval, interval, TimeUnit.MILLISECONDS);
    }

    public int incrementAndGet(String ip) {
        int index = 0;
        if (ip != null) {
            index = ip.hashCode() % this.slotCount;
        }
        if (index < 0) {
            index = -index;
        }
        return this.data[index].incrementAndGet();
    }

    public void rotateSlot() {
        int totalCount = 0;
        for (int i = 0; i < this.slotCount; ++i) {
            totalCount += this.data[i].get();
            this.data[i].set(0);
        }
        this.averageCount = totalCount / this.slotCount;
    }

    public int getCurrentCount(String ip) {
        int index = 0;
        if (ip != null) {
            index = ip.hashCode() % this.slotCount;
        }
        if (index < 0) {
            index = -index;
        }
        return this.data[index].get();
    }

    public int getAverageCount() {
        return this.averageCount;
    }

    class DefaultIPFlowDataManagerTask
    implements Runnable {
        DefaultIPFlowDataManagerTask() {
        }

        @Override
        public void run() {
            SimpleIPFlowData.this.rotateSlot();
        }
    }
}

