/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import com.alibaba.nacos.common.util.SystemUtils;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class PaginationHelper<E> {
    public Page<E> fetchPage(JdbcTemplate jt, String sqlCountRows, String sqlFetchRows, Object[] args, int pageNo, int pageSize, RowMapper<E> rowMapper) {
        return this.fetchPage(jt, sqlCountRows, sqlFetchRows, args, pageNo, pageSize, null, rowMapper);
    }

    public Page<E> fetchPage(JdbcTemplate jt, String sqlCountRows, String sqlFetchRows, Object[] args, int pageNo, int pageSize, Long lastMaxId, RowMapper<E> rowMapper) {
        int pageCount;
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
        Integer rowCountInt = (Integer)jt.queryForObject(sqlCountRows, Integer.class, args);
        if (rowCountInt == null) {
            throw new IllegalArgumentException("fetchPageLimit error");
        }
        int rowCount = rowCountInt;
        if (rowCount > pageSize * (pageCount = rowCount / pageSize)) {
            ++pageCount;
        }
        Page page = new Page();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(rowCount);
        if (pageNo > pageCount) {
            return null;
        }
        int startRow = (pageNo - 1) * pageSize;
        String selectSQL = "";
        selectSQL = SystemUtils.STANDALONE_MODE && !PropertyUtil.isStandaloneUseMysql() ? sqlFetchRows + " OFFSET " + startRow + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY" : (lastMaxId != null ? sqlFetchRows + " and id > " + lastMaxId + " order by id asc limit " + 0 + "," + pageSize : sqlFetchRows + " limit " + startRow + "," + pageSize);
        List result = jt.query(selectSQL, args, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    public Page<E> fetchPageLimit(JdbcTemplate jt, String sqlCountRows, String sqlFetchRows, Object[] args, int pageNo, int pageSize, RowMapper<E> rowMapper) {
        int pageCount;
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
        Integer rowCountInt = (Integer)jt.queryForObject(sqlCountRows, Integer.class);
        if (rowCountInt == null) {
            throw new IllegalArgumentException("fetchPageLimit error");
        }
        int rowCount = rowCountInt;
        if (rowCount > pageSize * (pageCount = rowCount / pageSize)) {
            ++pageCount;
        }
        Page page = new Page();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(rowCount);
        if (pageNo > pageCount) {
            return null;
        }
        String selectSQL = sqlFetchRows;
        if (SystemUtils.STANDALONE_MODE && !PropertyUtil.isStandaloneUseMysql()) {
            selectSQL = selectSQL.replaceAll("(?i)LIMIT \\?,\\?", "OFFSET ? ROWS FETCH NEXT ? ROWS ONLY");
        }
        List result = jt.query(selectSQL, args, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    public Page<E> fetchPageLimit(JdbcTemplate jt, String sqlCountRows, Object[] args1, String sqlFetchRows, Object[] args2, int pageNo, int pageSize, RowMapper<E> rowMapper) {
        int pageCount;
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
        Integer rowCountInt = (Integer)jt.queryForObject(sqlCountRows, Integer.class, args1);
        if (rowCountInt == null) {
            throw new IllegalArgumentException("fetchPageLimit error");
        }
        int rowCount = rowCountInt;
        if (rowCount > pageSize * (pageCount = rowCount / pageSize)) {
            ++pageCount;
        }
        Page page = new Page();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(rowCount);
        if (pageNo > pageCount) {
            return null;
        }
        String selectSQL = sqlFetchRows;
        if (SystemUtils.STANDALONE_MODE && !PropertyUtil.isStandaloneUseMysql()) {
            selectSQL = selectSQL.replaceAll("(?i)LIMIT \\?,\\?", "OFFSET ? ROWS FETCH NEXT ? ROWS ONLY");
        }
        List result = jt.query(selectSQL, args2, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    public Page<E> fetchPageLimit(JdbcTemplate jt, String sqlFetchRows, Object[] args, int pageNo, int pageSize, RowMapper<E> rowMapper) {
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
        Page page = new Page();
        String selectSQL = sqlFetchRows;
        if (SystemUtils.STANDALONE_MODE && !PropertyUtil.isStandaloneUseMysql()) {
            selectSQL = selectSQL.replaceAll("(?i)LIMIT \\?,\\?", "OFFSET ? ROWS FETCH NEXT ? ROWS ONLY");
        }
        List result = jt.query(selectSQL, args, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    public void updateLimit(JdbcTemplate jt, String sql, Object[] args) {
        String sqlUpdate = sql;
        if (SystemUtils.STANDALONE_MODE && !PropertyUtil.isStandaloneUseMysql()) {
            sqlUpdate = sqlUpdate.replaceAll("limit \\?", "OFFSET 0 ROWS FETCH NEXT ? ROWS ONLY");
        }
        jt.update(sqlUpdate, args);
    }
}

