/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.notify;

import com.alibaba.nacos.common.util.SystemUtils;
import com.alibaba.nacos.config.server.manager.AbstractTask;
import com.alibaba.nacos.config.server.manager.TaskProcessor;
import com.alibaba.nacos.config.server.monitor.MetricsMonitor;
import com.alibaba.nacos.config.server.service.ServerListService;
import com.alibaba.nacos.config.server.service.notify.NotifyService;
import com.alibaba.nacos.config.server.service.notify.NotifyTask;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.RunningConfigUtils;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyTaskProcessor
implements TaskProcessor {
    static final Logger log = LoggerFactory.getLogger(NotifyTaskProcessor.class);
    static final String URL_PATTERN = "http://{0}{1}/v1/cs/communication/dataChange?dataId={2}&group={3}";
    final ServerListService serverListService;

    public NotifyTaskProcessor(ServerListService serverListService) {
        this.serverListService = serverListService;
    }

    @Override
    public boolean process(String taskType, AbstractTask task) {
        NotifyTask notifyTask = (NotifyTask)task;
        String dataId = notifyTask.getDataId();
        String group = notifyTask.getGroup();
        String tenant = notifyTask.getTenant();
        long lastModified = notifyTask.getLastModified();
        boolean isok = true;
        for (String ip : this.serverListService.getServerList()) {
            isok = this.notifyToDump(dataId, group, tenant, lastModified, ip) && isok;
        }
        return isok;
    }

    boolean notifyToDump(String dataId, String group, String tenant, long lastModified, String serverIp) {
        long delayed = System.currentTimeMillis() - lastModified;
        try {
            List<String> headers = Arrays.asList("lastModified", String.valueOf(lastModified), "opHandleIp", SystemUtils.LOCAL_IP);
            String urlString = MessageFormat.format(URL_PATTERN, serverIp, RunningConfigUtils.getContextPath(), dataId, group);
            NotifyService.HttpResult result = NotifyService.invokeURL(urlString, headers, "UTF-8");
            if (result.code == 200) {
                ConfigTraceService.logNotifyEvent(dataId, group, tenant, null, lastModified, SystemUtils.LOCAL_IP, "ok", delayed, serverIp);
                MetricsMonitor.getNotifyRtTimer().record(delayed, TimeUnit.MILLISECONDS);
                return true;
            }
            MetricsMonitor.getConfigNotifyException().increment();
            log.error("[notify-error] {}, {}, to {}, result {}", new Object[]{dataId, group, serverIp, result.code});
            ConfigTraceService.logNotifyEvent(dataId, group, tenant, null, lastModified, SystemUtils.LOCAL_IP, "error", delayed, serverIp);
            return false;
        }
        catch (Exception e) {
            MetricsMonitor.getConfigNotifyException().increment();
            log.error("[notify-exception] " + dataId + ", " + group + ", to " + serverIp + ", " + e.toString());
            log.debug("[notify-exception] " + dataId + ", " + group + ", to " + serverIp + ", " + e.toString(), (Throwable)e);
            ConfigTraceService.logNotifyEvent(dataId, group, tenant, null, lastModified, SystemUtils.LOCAL_IP, "exception", delayed, serverIp);
            return false;
        }
    }
}

