/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.notify;

import com.alibaba.nacos.config.server.manager.AbstractTask;
import com.alibaba.nacos.config.server.service.ServerListService;
import com.alibaba.nacos.config.server.service.notify.NotifyTask;
import com.alibaba.nacos.config.server.service.notify.NotifyTaskProcessor;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class NotifySingleService {
    private static final Logger logger = LogUtil.fatalLog;
    private ServerListService serverListService;
    private ConcurrentHashMap<String, Executor> executors = new ConcurrentHashMap();

    @Autowired
    public NotifySingleService(ServerListService serverListService) {
        this.serverListService = serverListService;
        this.setupNotifyExecutors();
    }

    private void setupNotifyExecutors() {
        List<String> clusterIps = this.serverListService.getServerList();
        for (String string : clusterIps) {
            ScheduledExecutorService executor;
            if (null != this.executors.putIfAbsent(string, executor = Executors.newScheduledThreadPool(1, new NotifyThreadFactory(string)))) continue;
            logger.warn("[notify-thread-pool] setup thread target ip {} ok.", (Object)string);
        }
        for (Map.Entry entry : this.executors.entrySet()) {
            String target = (String)entry.getKey();
            if (clusterIps.contains(target)) continue;
            ThreadPoolExecutor executor = (ThreadPoolExecutor)entry.getValue();
            executor.shutdown();
            this.executors.remove(target);
            logger.warn("[notify-thread-pool] tear down thread target ip {} ok.", (Object)target);
        }
    }

    public ConcurrentHashMap<String, Executor> getExecutors() {
        return this.executors;
    }

    static class NotifyThreadFactory
    implements ThreadFactory {
        private final String notifyTarget;

        NotifyThreadFactory(String notifyTarget) {
            this.notifyTarget = notifyTarget;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "com.alibaba.nacos.NotifySingleServiceThread-" + this.notifyTarget);
            thread.setDaemon(true);
            return thread;
        }
    }

    static class NotifySingleTask
    extends NotifyTask
    implements Runnable {
        private static final NotifyTaskProcessorWrapper PROCESSOR = new NotifyTaskProcessorWrapper();
        private final Executor executor;
        private final String target;
        private boolean isSuccess = false;

        public NotifySingleTask(String dataId, String group, String tenant, long lastModified, String target, Executor executor) {
            super(dataId, group, tenant, lastModified);
            this.target = target;
            this.executor = executor;
        }

        @Override
        public void run() {
            try {
                this.isSuccess = PROCESSOR.process(GroupKey2.getKey(this.getDataId(), this.getGroup()), this);
            }
            catch (Exception e) {
                this.isSuccess = false;
                LogUtil.notifyLog.error("[notify-exception] target:{} dataid:{} group:{} ts:{}", new Object[]{this.target, this.getDataId(), this.getGroup(), this.getLastModified()});
                LogUtil.notifyLog.debug("[notify-exception] target:{} dataid:{} group:{} ts:{}", (Object)new Object[]{this.target, this.getDataId(), this.getGroup(), this.getLastModified()}, (Object)e);
            }
            if (!this.isSuccess) {
                LogUtil.notifyLog.error("[notify-retry] target:{} dataid:{} group:{} ts:{}", new Object[]{this.target, this.getDataId(), this.getGroup(), this.getLastModified()});
                try {
                    ((ScheduledThreadPoolExecutor)this.executor).schedule(this, 500L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    logger.warn("[notify-thread-pool] cluster remove node {}, current thread was tear down.", (Object)this.target, (Object)e);
                }
            }
        }
    }

    static class NotifyTaskProcessorWrapper
    extends NotifyTaskProcessor {
        public NotifyTaskProcessorWrapper() {
            super(null);
        }

        @Override
        public boolean process(String taskType, AbstractTask task) {
            NotifySingleTask notifyTask = (NotifySingleTask)task;
            return this.notifyToDump(notifyTask.getDataId(), notifyTask.getGroup(), notifyTask.getTenant(), notifyTask.getLastModified(), notifyTask.target);
        }
    }
}

