/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump;

import com.alibaba.nacos.common.util.SystemUtils;
import com.alibaba.nacos.config.server.manager.TaskManager;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoAggr;
import com.alibaba.nacos.config.server.model.ConfigInfoChanged;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.ConfigService;
import com.alibaba.nacos.config.server.service.DiskUtil;
import com.alibaba.nacos.config.server.service.PersistService;
import com.alibaba.nacos.config.server.service.ServerListService;
import com.alibaba.nacos.config.server.service.TimerTaskService;
import com.alibaba.nacos.config.server.service.dump.DumpAllBetaProcessor;
import com.alibaba.nacos.config.server.service.dump.DumpAllBetaTask;
import com.alibaba.nacos.config.server.service.dump.DumpAllProcessor;
import com.alibaba.nacos.config.server.service.dump.DumpAllTagProcessor;
import com.alibaba.nacos.config.server.service.dump.DumpAllTagTask;
import com.alibaba.nacos.config.server.service.dump.DumpAllTask;
import com.alibaba.nacos.config.server.service.dump.DumpChangeProcessor;
import com.alibaba.nacos.config.server.service.dump.DumpChangeTask;
import com.alibaba.nacos.config.server.service.dump.DumpProcessor;
import com.alibaba.nacos.config.server.service.dump.DumpTask;
import com.alibaba.nacos.config.server.service.merge.MergeTaskProcessor;
import com.alibaba.nacos.config.server.utils.ContentUtils;
import com.alibaba.nacos.config.server.utils.GroupKey;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.MD5;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class DumpService {
    @Autowired
    private Environment env;
    @Autowired
    PersistService persistService;
    static final int DUMP_ALL_INTERVAL_IN_MINUTE = 360;
    static final int INITIAL_DELAY_IN_MINUTE = 360;
    private TaskManager dumpTaskMgr;
    private TaskManager dumpAllTaskMgr;
    private static final Logger log = LoggerFactory.getLogger(DumpService.class);
    static final AtomicInteger FINISHED = new AtomicInteger();
    static final int INIT_THREAD_COUNT = 10;
    int total = 0;
    private static final String TRUE_STR = "true";
    private static final String BETA_TABLE_NAME = "config_info_beta";
    private static final String TAG_TABLE_NAME = "config_info_tag";
    Boolean isQuickStart = false;

    @PostConstruct
    public void init() {
        LogUtil.defaultLog.warn("DumpService start");
        DumpProcessor processor = new DumpProcessor(this);
        DumpAllProcessor dumpAllProcessor = new DumpAllProcessor(this);
        DumpAllBetaProcessor dumpAllBetaProcessor = new DumpAllBetaProcessor(this);
        DumpAllTagProcessor dumpAllTagProcessor = new DumpAllTagProcessor(this);
        this.dumpTaskMgr = new TaskManager("com.alibaba.nacos.server.DumpTaskManager");
        this.dumpTaskMgr.setDefaultTaskProcessor(processor);
        this.dumpAllTaskMgr = new TaskManager("com.alibaba.nacos.server.DumpAllTaskManager");
        this.dumpAllTaskMgr.setDefaultTaskProcessor(dumpAllProcessor);
        Runnable dumpAll = new Runnable(){

            @Override
            public void run() {
                DumpService.this.dumpAllTaskMgr.addTask("dumpAllConfigTask", new DumpAllTask());
            }
        };
        Runnable dumpAllBeta = new Runnable(){

            @Override
            public void run() {
                DumpService.this.dumpAllTaskMgr.addTask("dumpAllBetaConfigTask", new DumpAllBetaTask());
            }
        };
        Runnable clearConfigHistory = new Runnable(){

            @Override
            public void run() {
                log.warn("clearConfigHistory start");
                if (ServerListService.isFirstIp().booleanValue()) {
                    try {
                        Timestamp startTime = DumpService.this.getBeforeStamp(TimeUtils.getCurrentTime(), 720);
                        int totalCount = DumpService.this.persistService.findConfigHistoryCountByTime(startTime);
                        if (totalCount > 0) {
                            int removeTime;
                            int pageSize = 1000;
                            log.warn("clearConfigHistory, getBeforeStamp:{}, totalCount:{}, pageSize:{}, removeTime:{}", new Object[]{startTime, totalCount, pageSize, removeTime});
                            for (removeTime = (totalCount + pageSize - 1) / pageSize; removeTime > 0; --removeTime) {
                                DumpService.this.persistService.removeConfigHistory(startTime, pageSize);
                            }
                        }
                    }
                    catch (Throwable e) {
                        log.error("clearConfigHistory error", e);
                    }
                }
            }
        };
        try {
            List<ConfigInfoChanged> configList;
            this.dumpConfigInfo(dumpAllProcessor);
            LogUtil.defaultLog.info("start clear all config-info-beta.");
            DiskUtil.clearAllBeta();
            if (this.persistService.isExistTable(BETA_TABLE_NAME)) {
                dumpAllBetaProcessor.process("dumpAllBetaConfigTask", new DumpAllBetaTask());
            }
            LogUtil.defaultLog.info("start clear all config-info-tag.");
            DiskUtil.clearAllTag();
            if (this.persistService.isExistTable(TAG_TABLE_NAME)) {
                dumpAllTagProcessor.process("dumpAllTagConfigTask", new DumpAllTagTask());
            }
            if ((configList = this.persistService.findAllAggrGroup()) != null && !configList.isEmpty()) {
                this.total = configList.size();
                List<List<ConfigInfoChanged>> splitList = DumpService.splitList(configList, 10);
                for (List<ConfigInfoChanged> list : splitList) {
                    MergeAllDataWorker work = new MergeAllDataWorker(list);
                    work.start();
                }
                log.info("server start, schedule merge end.");
            }
        }
        catch (Exception e) {
            LogUtil.fatalLog.error("Nacos Server did not start because dumpservice bean construction failure :\n" + e.getMessage(), e.getCause());
            throw new RuntimeException("Nacos Server did not start because dumpservice bean construction failure :\n" + e.getMessage());
        }
        if (!SystemUtils.STANDALONE_MODE) {
            Runnable heartbeat = new Runnable(){

                @Override
                public void run() {
                    String heartBeatTime = TimeUtils.getCurrentTime().toString();
                    try {
                        DiskUtil.saveHeartBeatToDisk(heartBeatTime);
                    }
                    catch (IOException e) {
                        LogUtil.fatalLog.error("save heartbeat fail" + e.getMessage());
                    }
                }
            };
            TimerTaskService.scheduleWithFixedDelay(heartbeat, 0L, 10L, TimeUnit.SECONDS);
            long initialDelay = new Random().nextInt(360) + 10;
            LogUtil.defaultLog.warn("initialDelay:{}", (Object)initialDelay);
            TimerTaskService.scheduleWithFixedDelay(dumpAll, initialDelay, 360L, TimeUnit.MINUTES);
            TimerTaskService.scheduleWithFixedDelay(dumpAllBeta, initialDelay, 360L, TimeUnit.MINUTES);
        }
        TimerTaskService.scheduleWithFixedDelay(clearConfigHistory, 10L, 10L, TimeUnit.MINUTES);
    }

    private void dumpConfigInfo(DumpAllProcessor dumpAllProcessor) throws IOException {
        int timeStep = 6;
        Boolean isAllDump = true;
        FileInputStream fis = null;
        Timestamp heartheatLastStamp = null;
        try {
            File heartbeatFile;
            if (this.isQuickStart().booleanValue() && (heartbeatFile = DiskUtil.heartBeatFile()).exists()) {
                fis = new FileInputStream(heartbeatFile);
                String heartheatTempLast = IOUtils.toString((InputStream)fis, (String)"UTF-8");
                heartheatLastStamp = Timestamp.valueOf(heartheatTempLast);
                if (TimeUtils.getCurrentTime().getTime() - heartheatLastStamp.getTime() < (long)(timeStep * 60 * 60 * 1000)) {
                    isAllDump = false;
                }
            }
            if (isAllDump.booleanValue()) {
                LogUtil.defaultLog.info("start clear all config-info.");
                DiskUtil.clearAll();
                dumpAllProcessor.process("dumpAllConfigTask", new DumpAllTask());
            } else {
                Timestamp beforeTimeStamp = this.getBeforeStamp(heartheatLastStamp, timeStep);
                DumpChangeProcessor dumpChangeProcessor = new DumpChangeProcessor(this, beforeTimeStamp, TimeUtils.getCurrentTime());
                dumpChangeProcessor.process("dumpChangeConfigTask", new DumpChangeTask());
                Runnable checkMd5Task = new Runnable(){

                    @Override
                    public void run() {
                        LogUtil.defaultLog.error("start checkMd5Task");
                        List<String> diffList = ConfigService.checkMd5();
                        for (String groupKey : diffList) {
                            String[] dg = GroupKey.parseKey(groupKey);
                            String dataId = dg[0];
                            String group = dg[1];
                            String tenant = dg[2];
                            PersistService.ConfigInfoWrapper configInfo = DumpService.this.persistService.queryConfigInfo(dataId, group, tenant);
                            ConfigService.dumpChange(dataId, group, tenant, configInfo.getContent(), configInfo.getLastModified());
                        }
                        LogUtil.defaultLog.error("end checkMd5Task");
                    }
                };
                TimerTaskService.scheduleWithFixedDelay(checkMd5Task, 0L, 12L, TimeUnit.HOURS);
            }
        }
        catch (IOException e) {
            LogUtil.fatalLog.error("dump config fail" + e.getMessage());
            throw e;
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LogUtil.defaultLog.warn("close file failed");
                }
            }
        }
    }

    private Timestamp getBeforeStamp(Timestamp date, int step) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(11, -step);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return Timestamp.valueOf(format.format(cal.getTime()));
    }

    private Boolean isQuickStart() {
        try {
            String val = null;
            val = this.env.getProperty("isQuickStart");
            if (val != null && TRUE_STR.equals(val)) {
                this.isQuickStart = true;
            }
            LogUtil.fatalLog.warn("isQuickStart:{}", (Object)this.isQuickStart);
        }
        catch (Exception e) {
            LogUtil.fatalLog.error("read application.properties wrong", (Throwable)e);
        }
        return this.isQuickStart;
    }

    public void dump(String dataId, String group, String tenant, String tag, long lastModified, String handleIp) {
        this.dump(dataId, group, tenant, tag, lastModified, handleIp, false);
    }

    public void dump(String dataId, String group, String tenant, long lastModified, String handleIp) {
        this.dump(dataId, group, tenant, lastModified, handleIp, false);
    }

    public void dump(String dataId, String group, String tenant, long lastModified, String handleIp, boolean isBeta) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        this.dumpTaskMgr.addTask(groupKey, new DumpTask(groupKey, lastModified, handleIp, isBeta));
    }

    public void dump(String dataId, String group, String tenant, String tag, long lastModified, String handleIp, boolean isBeta) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        this.dumpTaskMgr.addTask(groupKey, new DumpTask(groupKey, tag, lastModified, handleIp, isBeta));
    }

    public void dumpAll() {
        this.dumpAllTaskMgr.addTask("dumpAllConfigTask", new DumpAllTask());
    }

    static List<List<ConfigInfoChanged>> splitList(List<ConfigInfoChanged> list, int count) {
        int i;
        ArrayList<List<ConfigInfoChanged>> result = new ArrayList<List<ConfigInfoChanged>>(count);
        for (i = 0; i < count; ++i) {
            result.add(new ArrayList());
        }
        for (i = 0; i < list.size(); ++i) {
            ConfigInfoChanged config = list.get(i);
            ((List)result.get(i % count)).add(config);
        }
        return result;
    }

    class MergeAllDataWorker
    extends Thread {
        static final int PAGE_SIZE = 10000;
        private List<ConfigInfoChanged> configInfoList;

        public MergeAllDataWorker(List<ConfigInfoChanged> configInfoList) {
            super("MergeAllDataWorker");
            this.configInfoList = configInfoList;
        }

        @Override
        public void run() {
            for (ConfigInfoChanged configInfo : this.configInfoList) {
                String dataId = configInfo.getDataId();
                String group = configInfo.getGroup();
                String tenant = configInfo.getTenant();
                try {
                    ArrayList<ConfigInfoAggr> datumList = new ArrayList<ConfigInfoAggr>();
                    int rowCount = DumpService.this.persistService.aggrConfigInfoCount(dataId, group, tenant);
                    int pageCount = (int)Math.ceil((double)rowCount * 1.0 / 10000.0);
                    for (int pageNo = 1; pageNo <= pageCount; ++pageNo) {
                        Page<ConfigInfoAggr> page = DumpService.this.persistService.findConfigInfoAggrByPage(dataId, group, tenant, pageNo, 10000);
                        if (page == null) continue;
                        datumList.addAll(page.getPageItems());
                        log.info("[merge-query] {}, {}, size/total={}/{}", new Object[]{dataId, group, datumList.size(), rowCount});
                    }
                    Timestamp time = TimeUtils.getCurrentTime();
                    if (datumList.size() > 0) {
                        String aggrConetentMD5;
                        ConfigInfo cf = MergeTaskProcessor.merge(dataId, group, tenant, datumList);
                        String aggrContent = cf.getContent();
                        String localContentMD5 = ConfigService.getContentMd5(GroupKey.getKey(dataId, group));
                        if (!StringUtils.equals((CharSequence)localContentMD5, (CharSequence)(aggrConetentMD5 = MD5.getInstance().getMD5String(aggrContent)))) {
                            DumpService.this.persistService.insertOrUpdate(null, null, cf, time, null, false);
                            log.info("[merge-ok] {}, {}, size={}, length={}, md5={}, content={}", new Object[]{dataId, group, datumList.size(), cf.getContent().length(), cf.getMd5(), ContentUtils.truncateContent(cf.getContent())});
                        }
                    } else {
                        DumpService.this.persistService.removeConfigInfo(dataId, group, tenant, SystemUtils.LOCAL_IP, null);
                        log.warn("[merge-delete] delete config info because no datum. dataId=" + dataId + ", groupId=" + group);
                    }
                }
                catch (Throwable e) {
                    log.info("[merge-error] " + dataId + ", " + group + ", " + e.toString(), e);
                }
                FINISHED.incrementAndGet();
                if (FINISHED.get() % 100 != 0) continue;
                log.info("[all-merge-dump] {} / {}", (Object)FINISHED.get(), (Object)DumpService.this.total);
            }
            log.info("[all-merge-dump] {} / {}", (Object)FINISHED.get(), (Object)DumpService.this.total);
        }
    }
}

