/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump;

import com.alibaba.nacos.config.server.manager.AbstractTask;
import com.alibaba.nacos.config.server.manager.TaskProcessor;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.ConfigService;
import com.alibaba.nacos.config.server.service.PersistService;
import com.alibaba.nacos.config.server.service.dump.DumpService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;

class DumpAllBetaProcessor
implements TaskProcessor {
    static final int PAGE_SIZE = 1000;
    final DumpService dumpService;
    final PersistService persistService;

    DumpAllBetaProcessor(DumpService dumpService) {
        this.dumpService = dumpService;
        this.persistService = dumpService.persistService;
    }

    @Override
    public boolean process(String taskType, AbstractTask task) {
        int rowCount = this.persistService.configInfoBetaCount();
        int pageCount = (int)Math.ceil((double)rowCount * 1.0 / 1000.0);
        int actualRowCount = 0;
        for (int pageNo = 1; pageNo <= pageCount; ++pageNo) {
            Page<PersistService.ConfigInfoBetaWrapper> page = this.persistService.findAllConfigInfoBetaForDumpAll(pageNo, 1000);
            if (page == null) continue;
            for (PersistService.ConfigInfoBetaWrapper cf : page.getPageItems()) {
                boolean result = ConfigService.dumpBeta(cf.getDataId(), cf.getGroup(), cf.getTenant(), cf.getContent(), cf.getLastModified(), cf.getBetaIps());
                LogUtil.dumpLog.info("[dump-all-beta-ok] result={}, {}, {}, length={}, md5={}", new Object[]{result, GroupKey2.getKey(cf.getDataId(), cf.getGroup()), cf.getLastModified(), cf.getContent().length(), cf.getMd5()});
            }
            LogUtil.defaultLog.info("[all-dump-beta] {} / {}", (Object)(actualRowCount += page.getPageItems().size()), (Object)rowCount);
        }
        return true;
    }
}

