/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.config.server.model.ConfigAdvanceInfo;
import com.alibaba.nacos.config.server.model.ConfigAllInfo;
import com.alibaba.nacos.config.server.model.ConfigHistoryInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo4Beta;
import com.alibaba.nacos.config.server.model.ConfigInfo4Tag;
import com.alibaba.nacos.config.server.model.ConfigInfoAggr;
import com.alibaba.nacos.config.server.model.ConfigInfoBase;
import com.alibaba.nacos.config.server.model.ConfigInfoChanged;
import com.alibaba.nacos.config.server.model.ConfigKey;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.model.SubInfo;
import com.alibaba.nacos.config.server.model.TenantInfo;
import com.alibaba.nacos.config.server.model.User;
import com.alibaba.nacos.config.server.service.ConfigDataChangeEvent;
import com.alibaba.nacos.config.server.service.DataSourceService;
import com.alibaba.nacos.config.server.service.DynamicDataSource;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.MD5;
import com.alibaba.nacos.config.server.utils.PaginationHelper;
import com.alibaba.nacos.config.server.utils.event.EventDispatcher;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;

@Repository
public class PersistService {
    @Autowired
    private DynamicDataSource dynamicDataSource;
    private DataSourceService dataSourceService;
    static final TenantInfoRowMapper TENANT_INFO_ROW_MAPPER = new TenantInfoRowMapper();
    static final UserRowMapper USER_ROW_MAPPER = new UserRowMapper();
    static final ConfigInfoWrapperRowMapper CONFIG_INFO_WRAPPER_ROW_MAPPER = new ConfigInfoWrapperRowMapper();
    static final ConfigKeyRowMapper CONFIG_KEY_ROW_MAPPER = new ConfigKeyRowMapper();
    static final ConfigInfoBetaWrapperRowMapper CONFIG_INFO_BETA_WRAPPER_ROW_MAPPER = new ConfigInfoBetaWrapperRowMapper();
    static final ConfigInfoTagWrapperRowMapper CONFIG_INFO_TAG_WRAPPER_ROW_MAPPER = new ConfigInfoTagWrapperRowMapper();
    static final ConfigInfoRowMapper CONFIG_INFO_ROW_MAPPER = new ConfigInfoRowMapper();
    static final ConfigAdvanceInfoRowMapper CONFIG_ADVANCE_INFO_ROW_MAPPER = new ConfigAdvanceInfoRowMapper();
    static final ConfigAllInfoRowMapper CONFIG_ALL_INFO_ROW_MAPPER = new ConfigAllInfoRowMapper();
    static final ConfigInfo4BetaRowMapper CONFIG_INFO4BETA_ROW_MAPPER = new ConfigInfo4BetaRowMapper();
    static final ConfigInfo4TagRowMapper CONFIG_INFO4TAG_ROW_MAPPER = new ConfigInfo4TagRowMapper();
    static final ConfigInfoBaseRowMapper CONFIG_INFO_BASE_ROW_MAPPER = new ConfigInfoBaseRowMapper();
    static final ConfigInfoAggrRowMapper CONFIG_INFO_AGGR_ROW_MAPPER = new ConfigInfoAggrRowMapper();
    static final ConfigInfoChangedRowMapper CONFIG_INFO_CHANGED_ROW_MAPPER = new ConfigInfoChangedRowMapper();
    static final ConfigHistoryRowMapper HISTORY_LIST_ROW_MAPPER = new ConfigHistoryRowMapper();
    static final ConfigHistoryDetailRowMapper HISTORY_DETAIL_ROW_MAPPER = new ConfigHistoryDetailRowMapper();
    private static String PATTERN_STR = "*";
    private static final int QUERY_LIMIT_SIZE = 50;
    private JdbcTemplate jt;
    private TransactionTemplate tjt;

    @PostConstruct
    public void init() {
        this.dataSourceService = this.dynamicDataSource.getDataSource();
        this.jt = this.getJdbcTemplate();
        this.tjt = this.getTransactionTemplate();
    }

    public boolean checkMasterWritable() {
        return this.dataSourceService.checkMasterWritable();
    }

    public void setBasicDataSourceService(DataSourceService dataSourceService) {
        this.dataSourceService = dataSourceService;
    }

    public synchronized void reload() throws IOException {
        this.dataSourceService.reload();
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.dataSourceService.getJdbcTemplate();
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.dataSourceService.getTransactionTemplate();
    }

    public String getCurrentDBUrl() {
        return this.dataSourceService.getCurrentDBUrl();
    }

    public void addConfigInfo(final String srcIp, final String srcUser, final ConfigInfo configInfo, final Timestamp time, final Map<String, Object> configAdvanceInfo, final boolean notify) {
        this.tjt.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus status) {
                try {
                    long configId = PersistService.this.addConfigInfoAtomic(srcIp, srcUser, configInfo, time, configAdvanceInfo);
                    String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
                    PersistService.this.addConfiTagsRelationAtomic(configId, configTags, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
                    PersistService.this.insertConfigHistoryAtomic(0L, configInfo, srcIp, srcUser, time, "I");
                    if (notify) {
                        EventDispatcher.fireEvent(new ConfigDataChangeEvent(false, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), time.getTime()));
                    }
                }
                catch (CannotGetJdbcConnectionException e) {
                    LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
                    throw e;
                }
                return Boolean.TRUE;
            }
        });
    }

    public void addConfigInfo4Beta(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((String)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((String)configInfo.getTenant()) ? "" : configInfo.getTenant();
        try {
            String md5 = MD5.getInstance().getMD5String(configInfo.getContent());
            this.jt.update("INSERT INTO config_info_beta(data_id,group_id,tenant_id,app_name,content,md5,beta_ips,src_ip,src_user,gmt_create,gmt_modified) VALUES(?,?,?,?,?,?,?,?,?,?,?)", new Object[]{configInfo.getDataId(), configInfo.getGroup(), tenantTmp, appNameTmp, configInfo.getContent(), md5, betaIps, srcIp, srcUser, time, time});
            if (notify) {
                EventDispatcher.fireEvent(new ConfigDataChangeEvent(true, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, time.getTime()));
            }
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public void addConfigInfo4Tag(ConfigInfo configInfo, String tag, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((String)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((String)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String tagTmp = StringUtils.isBlank((String)tag) ? "" : tag.trim();
        try {
            String md5 = MD5.getInstance().getMD5String(configInfo.getContent());
            this.jt.update("INSERT INTO config_info_tag(data_id,group_id,tenant_id,tag_id,app_name,content,md5,src_ip,src_user,gmt_create,gmt_modified) VALUES(?,?,?,?,?,?,?,?,?,?,?)", new Object[]{configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp, appNameTmp, configInfo.getContent(), md5, srcIp, srcUser, time, time});
            if (notify) {
                EventDispatcher.fireEvent(new ConfigDataChangeEvent(false, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp, time.getTime()));
            }
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public void updateConfigInfo(final ConfigInfo configInfo, final String srcIp, final String srcUser, final Timestamp time, final Map<String, Object> configAdvanceInfo, final boolean notify) {
        this.tjt.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus status) {
                try {
                    String configTags;
                    ConfigInfo oldConfigInfo = PersistService.this.findConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
                    String appNameTmp = oldConfigInfo.getAppName();
                    if (configInfo.getAppName() == null) {
                        configInfo.setAppName(appNameTmp);
                    }
                    PersistService.this.updateConfigInfoAtomic(configInfo, srcIp, srcUser, time, configAdvanceInfo);
                    String string = configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
                    if (configTags != null) {
                        PersistService.this.removeTagByIdAtomic(oldConfigInfo.getId());
                        PersistService.this.addConfiTagsRelationAtomic(oldConfigInfo.getId(), configTags, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
                    }
                    PersistService.this.insertConfigHistoryAtomic(oldConfigInfo.getId(), oldConfigInfo, srcIp, srcUser, time, "U");
                    if (notify) {
                        EventDispatcher.fireEvent(new ConfigDataChangeEvent(false, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), time.getTime()));
                    }
                }
                catch (CannotGetJdbcConnectionException e) {
                    LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
                    throw e;
                }
                return Boolean.TRUE;
            }
        });
    }

    public void updateConfigInfo4Beta(ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((String)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((String)configInfo.getTenant()) ? "" : configInfo.getTenant();
        try {
            String md5 = MD5.getInstance().getMD5String(configInfo.getContent());
            this.jt.update("UPDATE config_info_beta SET content=?, md5 = ?, src_ip=?,src_user=?,gmt_modified=?,app_name=? WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{configInfo.getContent(), md5, srcIp, srcUser, time, appNameTmp, configInfo.getDataId(), configInfo.getGroup(), tenantTmp});
            if (notify) {
                EventDispatcher.fireEvent(new ConfigDataChangeEvent(true, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, time.getTime()));
            }
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public void updateConfigInfo4Tag(ConfigInfo configInfo, String tag, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((String)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((String)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String tagTmp = StringUtils.isBlank((String)tag) ? "" : tag.trim();
        try {
            String md5 = MD5.getInstance().getMD5String(configInfo.getContent());
            this.jt.update("UPDATE config_info_tag SET content=?, md5 = ?, src_ip=?,src_user=?,gmt_modified=?,app_name=? WHERE data_id=? AND group_id=? AND tenant_id=? AND tag_id=?", new Object[]{configInfo.getContent(), md5, srcIp, srcUser, time, appNameTmp, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp});
            if (notify) {
                EventDispatcher.fireEvent(new ConfigDataChangeEvent(true, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp, time.getTime()));
            }
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public void insertOrUpdateBeta(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        try {
            this.addConfigInfo4Beta(configInfo, betaIps, srcIp, null, time, notify);
        }
        catch (DataIntegrityViolationException ive) {
            this.updateConfigInfo4Beta(configInfo, srcIp, null, time, notify);
        }
    }

    public void insertOrUpdateTag(ConfigInfo configInfo, String tag, String srcIp, String srcUser, Timestamp time, boolean notify) {
        try {
            this.addConfigInfo4Tag(configInfo, tag, srcIp, null, time, notify);
        }
        catch (DataIntegrityViolationException ive) {
            this.updateConfigInfo4Tag(configInfo, tag, srcIp, null, time, notify);
        }
    }

    public void updateMd5(String dataId, String group, String tenant, String md5, Timestamp lastTime) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        try {
            this.jt.update("UPDATE config_info SET md5 = ? WHERE data_id=? AND group_id=? AND tenant_id=? AND gmt_modified=?", new Object[]{md5, dataId, group, tenantTmp, lastTime});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public void insertOrUpdate(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo) {
        this.insertOrUpdate(srcIp, srcUser, configInfo, time, configAdvanceInfo, true);
    }

    public void insertOrUpdate(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        try {
            this.addConfigInfo(srcIp, srcUser, configInfo, time, configAdvanceInfo, notify);
        }
        catch (DataIntegrityViolationException ive) {
            this.updateConfigInfo(configInfo, srcIp, srcUser, time, configAdvanceInfo, notify);
        }
    }

    public void insertOrUpdateSub(SubInfo subInfo) {
        try {
            this.addConfigSubAtomic(subInfo.getDataId(), subInfo.getGroup(), subInfo.getAppName(), subInfo.getDate());
        }
        catch (DataIntegrityViolationException ive) {
            this.updateConfigSubAtomic(subInfo.getDataId(), subInfo.getGroup(), subInfo.getAppName(), subInfo.getDate());
        }
    }

    public void removeConfigInfo(final String dataId, final String group, final String tenant, final String srcIp, final String srcUser) {
        this.tjt.execute((TransactionCallback)new TransactionCallback<Boolean>(){
            final Timestamp time = new Timestamp(System.currentTimeMillis());

            public Boolean doInTransaction(TransactionStatus status) {
                try {
                    ConfigInfo configInfo = PersistService.this.findConfigInfo(dataId, group, tenant);
                    if (configInfo != null) {
                        PersistService.this.removeConfigInfoAtomic(dataId, group, tenant, srcIp, srcUser);
                        PersistService.this.removeTagByIdAtomic(configInfo.getId());
                        PersistService.this.insertConfigHistoryAtomic(configInfo.getId(), configInfo, srcIp, srcUser, this.time, "D");
                    }
                }
                catch (CannotGetJdbcConnectionException e) {
                    LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
                    throw e;
                }
                return Boolean.TRUE;
            }
        });
    }

    public void removeConfigInfo4Beta(final String dataId, final String group, final String tenant) {
        final String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        this.tjt.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus status) {
                try {
                    ConfigInfo4Beta configInfo = PersistService.this.findConfigInfo4Beta(dataId, group, tenant);
                    if (configInfo != null) {
                        PersistService.this.jt.update("DELETE FROM config_info_beta WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, tenantTmp});
                    }
                }
                catch (CannotGetJdbcConnectionException e) {
                    LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
                    throw e;
                }
                return Boolean.TRUE;
            }
        });
    }

    public boolean addAggrConfigInfo(String dataId, String group, String tenant, String datumId, String appName, String content) {
        String appNameTmp = StringUtils.isBlank((String)appName) ? "" : appName;
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String select = "SELECT content FROM config_info_aggr WHERE data_id = ? AND group_id = ? AND tenant_id = ?  AND datum_id = ?";
        String insert = "INSERT INTO config_info_aggr(data_id, group_id, tenant_id, datum_id, app_name, content, gmt_modified) VALUES(?,?,?,?,?,?,?) ";
        String update = "UPDATE config_info_aggr SET content = ? , gmt_modified = ? WHERE data_id = ? AND group_id = ? AND tenant_id = ? AND datum_id = ?";
        try {
            try {
                String dbContent = (String)this.jt.queryForObject(select, new Object[]{dataId, group, tenantTmp, datumId}, String.class);
                if (dbContent != null && dbContent.equals(content)) {
                    return true;
                }
                return this.jt.update(update, new Object[]{content, now, dataId, group, tenantTmp, datumId}) > 0;
            }
            catch (EmptyResultDataAccessException ex) {
                return this.jt.update(insert, new Object[]{dataId, group, tenantTmp, datumId, appNameTmp, content, now}) > 0;
            }
        }
        catch (DataAccessException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public void removeSingleAggrConfigInfo(final String dataId, final String group, String tenant, final String datumId) {
        final String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        String sql = "DELETE FROM config_info_aggr WHERE data_id=? AND group_id=? AND tenant_id=? AND datum_id=?";
        try {
            this.jt.update(sql, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    int index = 1;
                    ps.setString(index++, dataId);
                    ps.setString(index++, group);
                    ps.setString(index++, tenantTmp);
                    ps.setString(index++, datumId);
                }
            });
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public void removeAggrConfigInfo(final String dataId, final String group, String tenant) {
        final String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        String sql = "DELETE FROM config_info_aggr WHERE data_id=? AND group_id=? AND tenant_id=?";
        try {
            this.jt.update(sql, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    int index = 1;
                    ps.setString(index++, dataId);
                    ps.setString(index++, group);
                    ps.setString(index++, tenantTmp);
                }
            });
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public boolean batchRemoveAggr(String dataId, String group, String tenant, List<String> datumList) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        StringBuilder datumString = new StringBuilder();
        for (String datum : datumList) {
            datumString.append("'").append(datum).append("',");
        }
        datumString.deleteCharAt(datumString.length() - 1);
        String sql = "delete from config_info_aggr where data_id=? and group_id=? and tenant_id=? and datum_id in (" + datumString.toString() + ")";
        try {
            this.jt.update(sql, new Object[]{dataId, group, tenantTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            return false;
        }
        return true;
    }

    public void removeConfigHistory(Timestamp startTime, int limitSize) {
        String sql = "delete from his_config_info where gmt_modified < ? limit ?";
        PaginationHelper helper = new PaginationHelper();
        try {
            helper.updateLimit(this.jt, sql, new Object[]{startTime, limitSize});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public int findConfigHistoryCountByTime(Timestamp startTime) {
        String sql = "SELECT COUNT(*) FROM his_config_info WHERE gmt_modified < ?";
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class, new Object[]{startTime});
        if (result == null) {
            throw new IllegalArgumentException("configInfoBetaCount error");
        }
        return result;
    }

    public long findConfigMaxId() {
        String sql = "SELECT max(id) FROM config_info";
        try {
            return ((Integer)this.jt.queryForObject(sql, Integer.class)).intValue();
        }
        catch (NullPointerException e) {
            return 0L;
        }
    }

    public boolean batchPublishAggr(final String dataId, final String group, final String tenant, final Map<String, String> datumMap, final String appName) {
        try {
            Boolean isPublishOk = (Boolean)this.tjt.execute((TransactionCallback)new TransactionCallback<Boolean>(){

                public Boolean doInTransaction(TransactionStatus status) {
                    for (Map.Entry entry : datumMap.entrySet()) {
                        try {
                            if (PersistService.this.addAggrConfigInfo(dataId, group, tenant, (String)entry.getKey(), appName, (String)entry.getValue())) continue;
                            throw new TransactionSystemException("error in addAggrConfigInfo");
                        }
                        catch (Throwable e) {
                            throw new TransactionSystemException("error in addAggrConfigInfo");
                        }
                    }
                    return Boolean.TRUE;
                }
            });
            if (isPublishOk == null) {
                return false;
            }
            return isPublishOk;
        }
        catch (TransactionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            return false;
        }
    }

    public boolean replaceAggr(final String dataId, final String group, final String tenant, final Map<String, String> datumMap, final String appName) {
        try {
            Boolean isReplaceOk = (Boolean)this.tjt.execute((TransactionCallback)new TransactionCallback<Boolean>(){

                public Boolean doInTransaction(TransactionStatus status) {
                    try {
                        String appNameTmp = appName == null ? "" : appName;
                        PersistService.this.removeAggrConfigInfo(dataId, group, tenant);
                        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
                        String sql = "INSERT INTO config_info_aggr(data_id, group_id, tenant_id, datum_id, app_name, content, gmt_modified) VALUES(?,?,?,?,?,?,?) ";
                        for (Map.Entry datumEntry : datumMap.entrySet()) {
                            PersistService.this.jt.update(sql, new Object[]{dataId, group, tenantTmp, datumEntry.getKey(), appNameTmp, datumEntry.getValue(), new Timestamp(System.currentTimeMillis())});
                        }
                    }
                    catch (Throwable e) {
                        throw new TransactionSystemException("error in addAggrConfigInfo");
                    }
                    return Boolean.TRUE;
                }
            });
            if (isReplaceOk == null) {
                return false;
            }
            return isReplaceOk;
        }
        catch (TransactionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            return false;
        }
    }

    @Deprecated
    public List<ConfigInfo> findAllDataIdAndGroup() {
        String sql = "SELECT DISTINCT data_id, group_id FROM config_info";
        try {
            return this.jt.query(sql, new Object[0], (RowMapper)CONFIG_INFO_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return Collections.emptyList();
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LogUtil.fatalLog.error("[db-other-error]" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ConfigInfo4Beta findConfigInfo4Beta(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        try {
            return (ConfigInfo4Beta)this.jt.queryForObject("SELECT ID,data_id,group_id,tenant_id,app_name,content,beta_ips FROM config_info_beta WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, tenantTmp}, (RowMapper)CONFIG_INFO4BETA_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public ConfigInfo4Tag findConfigInfo4Tag(String dataId, String group, String tenant, String tag) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        String tagTmp = StringUtils.isBlank((String)tag) ? "" : tag.trim();
        try {
            return (ConfigInfo4Tag)this.jt.queryForObject("SELECT ID,data_id,group_id,tenant_id,tag_id,app_name,content FROM config_info_tag WHERE data_id=? AND group_id=? AND tenant_id=? AND tag_id=?", new Object[]{dataId, group, tenantTmp, tagTmp}, (RowMapper)CONFIG_INFO4TAG_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public ConfigInfo findConfigInfoApp(String dataId, String group, String tenant, String appName) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        try {
            return (ConfigInfo)this.jt.queryForObject("SELECT ID,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=? AND app_name=?", new Object[]{dataId, group, tenantTmp, appName}, (RowMapper)CONFIG_INFO_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public ConfigInfo findConfigInfoAdvanceInfo(String dataId, String group, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("appName");
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(dataId);
        paramList.add(group);
        paramList.add(tenantTmp);
        StringBuilder sql = new StringBuilder("select ID,data_id,group_id,tenant_id,app_name,content from config_info where data_id=? and group_id=? and tenant_id=? ");
        if (StringUtils.isNotBlank((String)configTags)) {
            sql = new StringBuilder("select a.ID,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content from config_info  a left join config_tags_relation b on a.id=b.id where a.data_id=? and a.group_id=? and a.tenant_id=? ");
            sql.append(" and b.tag_name in (");
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                if (i != 0) {
                    sql.append(", ");
                }
                sql.append("?");
                paramList.add(tagArr[i]);
            }
            sql.append(") ");
            if (StringUtils.isNotBlank((String)appName)) {
                sql.append(" and a.app_name=? ");
                paramList.add(appName);
            }
        } else if (StringUtils.isNotBlank((String)appName)) {
            sql.append(" and app_name=? ");
            paramList.add(appName);
        }
        try {
            return (ConfigInfo)this.jt.queryForObject(sql.toString(), paramList.toArray(), (RowMapper)CONFIG_INFO_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public ConfigInfoBase findConfigInfoBase(String dataId, String group) {
        try {
            return (ConfigInfoBase)this.jt.queryForObject("SELECT ID,data_id,group_id,content FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, ""}, (RowMapper)CONFIG_INFO_BASE_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public ConfigInfo findConfigInfo(long id) {
        try {
            return (ConfigInfo)this.jt.queryForObject("SELECT ID,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE ID=?", new Object[]{id}, (RowMapper)CONFIG_INFO_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigInfo> findConfigInfoByDataId(int pageNo, int pageSize, String dataId, String tenant) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = new PaginationHelper<ConfigInfo>();
        try {
            return helper.fetchPage(this.jt, "select count(*) from config_info where data_id=? and tenant_id=?", "select ID,data_id,group_id,tenant_id,app_name,content from config_info where data_id=? and tenant_id=?", new Object[]{dataId, tenantTmp}, pageNo, pageSize, CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigInfo> findConfigInfoByDataIdAndApp(int pageNo, int pageSize, String dataId, String tenant, String appName) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = new PaginationHelper<ConfigInfo>();
        try {
            return helper.fetchPage(this.jt, "select count(*) from config_info where data_id=? and tenant_id=? and app_name=?", "select ID,data_id,group_id,tenant_id,app_name,content from config_info where data_id=? and tenant_id=? and app_name=?", new Object[]{dataId, tenantTmp, appName}, pageNo, pageSize, CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigInfo> findConfigInfoByDataIdAndAdvance(int pageNo, int pageSize, String dataId, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = new PaginationHelper<ConfigInfo>();
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("appName");
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        StringBuilder sqlCount = new StringBuilder("select count(*) from config_info where data_id=? and tenant_id=? ");
        StringBuilder sql = new StringBuilder("select ID,data_id,group_id,tenant_id,app_name,content from config_info where data_id=? and tenant_id=? ");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(dataId);
        paramList.add(tenantTmp);
        if (StringUtils.isNotBlank((String)configTags)) {
            sqlCount = new StringBuilder("select count(*) from config_info  a left join config_tags_relation b on a.id=b.id where a.data_id=? and a.tenant_id=? ");
            sql = new StringBuilder("select a.ID,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content from config_info  a left join config_tags_relation b on a.id=b.id where a.data_id=? and a.tenant_id=? ");
            sqlCount.append(" and b.tag_name in (");
            sql.append(" and b.tag_name in (");
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                if (i != 0) {
                    sqlCount.append(", ");
                    sql.append(", ");
                }
                sqlCount.append("?");
                sql.append("?");
                paramList.add(tagArr[i]);
            }
            sqlCount.append(") ");
            sql.append(") ");
            if (StringUtils.isNotBlank((String)appName)) {
                sqlCount.append(" and a.app_name=? ");
                sql.append(" and a.app_name=? ");
                paramList.add(appName);
            }
        } else if (StringUtils.isNotBlank((String)appName)) {
            sqlCount.append(" and app_name=? ");
            sql.append(" and app_name=? ");
            paramList.add(appName);
        }
        try {
            return helper.fetchPage(this.jt, sqlCount.toString(), sql.toString(), paramList.toArray(), pageNo, pageSize, CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigInfo> findConfigInfo4Page(int pageNo, int pageSize, String dataId, String group, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = new PaginationHelper<ConfigInfo>();
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("appName");
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        String sqlCount = "select count(*) from config_info";
        String sql = "select ID,data_id,group_id,tenant_id,app_name,content from config_info";
        StringBuilder where = new StringBuilder(" where ");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(tenantTmp);
        if (StringUtils.isNotBlank((String)configTags)) {
            sqlCount = "select count(*) from config_info  a left join config_tags_relation b on a.id=b.id";
            sql = "select a.ID,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content from config_info  a left join config_tags_relation b on a.id=b.id";
            where.append(" a.tenant_id=? ");
            if (StringUtils.isNotBlank((String)dataId)) {
                where.append(" and a.data_id=? ");
                paramList.add(dataId);
            }
            if (StringUtils.isNotBlank((String)group)) {
                where.append(" and a.group_id=? ");
                paramList.add(group);
            }
            if (StringUtils.isNotBlank((String)appName)) {
                where.append(" and a.app_name=? ");
                paramList.add(appName);
            }
            where.append(" and b.tag_name in (");
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                if (i != 0) {
                    where.append(", ");
                }
                where.append("?");
                paramList.add(tagArr[i]);
            }
            where.append(") ");
        } else {
            where.append(" tenant_id=? ");
            if (StringUtils.isNotBlank((String)dataId)) {
                where.append(" and data_id=? ");
                paramList.add(dataId);
            }
            if (StringUtils.isNotBlank((String)group)) {
                where.append(" and group_id=? ");
                paramList.add(group);
            }
            if (StringUtils.isNotBlank((String)appName)) {
                where.append(" and app_name=? ");
                paramList.add(appName);
            }
        }
        try {
            return helper.fetchPage(this.jt, sqlCount + where, sql + where, paramList.toArray(), pageNo, pageSize, CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigInfoBase> findConfigInfoBaseByDataId(int pageNo, int pageSize, String dataId) {
        PaginationHelper<ConfigInfoBase> helper = new PaginationHelper<ConfigInfoBase>();
        try {
            return helper.fetchPage(this.jt, "select count(*) from config_info where data_id=? and tenant_id=?", "select ID,data_id,group_id,content from config_info where data_id=? and tenant_id=?", new Object[]{dataId, ""}, pageNo, pageSize, CONFIG_INFO_BASE_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigInfo> findConfigInfoByGroup(int pageNo, int pageSize, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = new PaginationHelper<ConfigInfo>();
        try {
            return helper.fetchPage(this.jt, "select count(*) from config_info where group_id=? and tenant_id=?", "select ID,data_id,group_id,tenant_id,app_name,content from config_info where group_id=? and tenant_id=?", new Object[]{group, tenantTmp}, pageNo, pageSize, CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigInfo> findConfigInfoByGroupAndApp(int pageNo, int pageSize, String group, String tenant, String appName) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = new PaginationHelper<ConfigInfo>();
        try {
            return helper.fetchPage(this.jt, "select count(*) from config_info where group_id=? and tenant_id=? and app_name =?", "select ID,data_id,group_id,tenant_id,app_name,content from config_info where group_id=? and tenant_id=? and app_name =?", new Object[]{group, tenantTmp, appName}, pageNo, pageSize, CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigInfo> findConfigInfoByGroupAndAdvance(int pageNo, int pageSize, String group, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = new PaginationHelper<ConfigInfo>();
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("appName");
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        StringBuilder sqlCount = new StringBuilder("select count(*) from config_info where group_id=? and tenant_id=? ");
        StringBuilder sql = new StringBuilder("select ID,data_id,group_id,tenant_id,app_name,content from config_info where group_id=? and tenant_id=? ");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(group);
        paramList.add(tenantTmp);
        if (StringUtils.isNotBlank((String)configTags)) {
            sqlCount = new StringBuilder("select count(*) from config_info  a left join config_tags_relation b on a.id=b.id where a.group_id=? and a.tenant_id=? ");
            sql = new StringBuilder("select a.ID,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content from config_info  a left join config_tags_relation b on a.id=b.id where a.group_id=? and a.tenant_id=? ");
            sqlCount.append(" and b.tag_name in (");
            sql.append(" and b.tag_name in (");
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                if (i != 0) {
                    sqlCount.append(", ");
                    sql.append(", ");
                }
                sqlCount.append("?");
                sql.append("?");
                paramList.add(tagArr[i]);
            }
            sqlCount.append(") ");
            sql.append(") ");
            if (StringUtils.isNotBlank((String)appName)) {
                sqlCount.append(" and a.app_name=? ");
                sql.append(" and a.app_name=? ");
                paramList.add(appName);
            }
        } else if (StringUtils.isNotBlank((String)appName)) {
            sqlCount.append(" and app_name=? ");
            sql.append(" and app_name=? ");
            paramList.add(appName);
        }
        try {
            return helper.fetchPage(this.jt, sqlCount.toString(), sql.toString(), paramList.toArray(), pageNo, pageSize, CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigInfo> findConfigInfoByApp(int pageNo, int pageSize, String tenant, String appName) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = new PaginationHelper<ConfigInfo>();
        try {
            return helper.fetchPage(this.jt, "select count(*) from config_info where tenant_id like ? and app_name=?", "select ID,data_id,group_id,tenant_id,app_name,content from config_info where tenant_id like ? and app_name=?", new Object[]{this.generateLikeArgument(tenantTmp), appName}, pageNo, pageSize, CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigInfo> findConfigInfoByAdvance(int pageNo, int pageSize, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = new PaginationHelper<ConfigInfo>();
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("appName");
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        StringBuilder sqlCount = new StringBuilder("select count(*) from config_info where tenant_id like ? ");
        StringBuilder sql = new StringBuilder("select ID,data_id,group_id,tenant_id,app_name,content from config_info where tenant_id like ? ");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(tenantTmp);
        if (StringUtils.isNotBlank((String)configTags)) {
            sqlCount = new StringBuilder("select count(*) from config_info a left join config_tags_relation b on a.id=b.id where a.tenant_id=? ");
            sql = new StringBuilder("select a.ID,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content from config_info  a left join config_tags_relation b on a.id=b.id where a.tenant_id=? ");
            sqlCount.append(" and b.tag_name in (");
            sql.append(" and b.tag_name in (");
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                if (i != 0) {
                    sqlCount.append(", ");
                    sql.append(", ");
                }
                sqlCount.append("?");
                sql.append("?");
                paramList.add(tagArr[i]);
            }
            sqlCount.append(") ");
            sql.append(") ");
            if (StringUtils.isNotBlank((String)appName)) {
                sqlCount.append(" and a.app_name=? ");
                sql.append(" and a.app_name=? ");
                paramList.add(appName);
            }
        } else if (StringUtils.isNotBlank((String)appName)) {
            sqlCount.append(" and app_name=? ");
            sql.append(" and app_name=? ");
            paramList.add(appName);
        }
        try {
            return helper.fetchPage(this.jt, sqlCount.toString(), sql.toString(), paramList.toArray(), pageNo, pageSize, CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigInfoBase> findConfigInfoBaseByGroup(int pageNo, int pageSize, String group) {
        PaginationHelper<ConfigInfoBase> helper = new PaginationHelper<ConfigInfoBase>();
        try {
            return helper.fetchPage(this.jt, "select count(*) from config_info where group_id=? and tenant_id=?", "select ID,data_id,group_id,content from config_info where group_id=? and tenant_id=?", new Object[]{group, ""}, pageNo, pageSize, CONFIG_INFO_BASE_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public int configInfoCount() {
        String sql = " SELECT COUNT(ID) FROM config_info ";
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoCount error");
        }
        return result;
    }

    public int configInfoCount(String tenant) {
        String sql = " SELECT COUNT(ID) FROM config_info where tenant_id like '" + tenant + "'";
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoCount error");
        }
        return result;
    }

    public int configInfoBetaCount() {
        String sql = " SELECT COUNT(ID) FROM config_info_beta ";
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoBetaCount error");
        }
        return result;
    }

    public int configInfoTagCount() {
        String sql = " SELECT COUNT(ID) FROM config_info_tag ";
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoBetaCount error");
        }
        return result;
    }

    public List<String> getTenantIdList(int page, int pageSize) {
        String sql = "SELECT tenant_id FROM config_info WHERE tenant_id != '' GROUP BY tenant_id LIMIT ?, ?";
        int from = (page - 1) * pageSize;
        return this.jt.queryForList(sql, String.class, new Object[]{from, pageSize});
    }

    public List<String> getGroupIdList(int page, int pageSize) {
        String sql = "SELECT group_id FROM config_info WHERE tenant_id ='' GROUP BY group_id LIMIT ?, ?";
        int from = (page - 1) * pageSize;
        return this.jt.queryForList(sql, String.class, new Object[]{from, pageSize});
    }

    public int aggrConfigInfoCount(String dataId, String group, String tenant) {
        String sql = " SELECT COUNT(ID) FROM config_info_aggr WHERE data_id = ? AND group_id = ? AND tenant_id = ?";
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class, new Object[]{dataId, group, tenantTmp});
        if (result == null) {
            throw new IllegalArgumentException("aggrConfigInfoCount error");
        }
        return result;
    }

    public int aggrConfigInfoCountIn(String dataId, String group, String tenant, List<String> datumIds) {
        return this.aggrConfigInfoCount(dataId, group, tenant, datumIds, true);
    }

    public int aggrConfigInfoCountNotIn(String dataId, String group, String tenant, List<String> datumIds) {
        return this.aggrConfigInfoCount(dataId, group, tenant, datumIds, false);
    }

    private int aggrConfigInfoCount(String dataId, String group, String tenant, List<String> datumIds, boolean isIn) {
        if (datumIds == null || datumIds.isEmpty()) {
            return 0;
        }
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        StringBuilder sql = new StringBuilder(" SELECT COUNT(*) FROM config_info_aggr WHERE data_id = ? and group_id = ? and tenant_id = ? and datum_id");
        if (isIn) {
            sql.append(" in (");
        } else {
            sql.append(" not in (");
        }
        int size = datumIds.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("?");
        }
        sql.append(")");
        ArrayList objectList = Lists.newArrayList((Object[])new Object[]{dataId, group, tenantTmp});
        objectList.addAll(datumIds);
        Integer result = (Integer)this.jt.queryForObject(sql.toString(), Integer.class, objectList.toArray());
        if (result == null) {
            throw new IllegalArgumentException("aggrConfigInfoCount error");
        }
        return result;
    }

    public Page<ConfigInfo> findAllConfigInfo(int pageNo, int pageSize, String tenant) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        String sqlCountRows = "SELECT COUNT(*) FROM config_info";
        String sqlFetchRows = " SELECT t.id,data_id,group_id,tenant_id,app_name,content,md5  FROM (                                  SELECT id FROM config_info            WHERE tenant_id like ?                     ORDER BY id LIMIT ?,?              ) g, config_info t                    WHERE g.id = t.id                    ";
        PaginationHelper<ConfigInfo> helper = new PaginationHelper<ConfigInfo>();
        try {
            return helper.fetchPageLimit(this.jt, sqlCountRows, sqlFetchRows, new Object[]{this.generateLikeArgument(tenantTmp), (pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigKey> findAllConfigKey(int pageNo, int pageSize, String tenant) {
        int pageCount;
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        String select = " SELECT data_id,group_id,app_name  FROM (                                  SELECT id FROM config_info            WHERE tenant_id LIKE ?                     ORDER BY id LIMIT ?, ?              ) g, config_info t                    WHERE g.id = t.id                    ";
        int totalCount = this.configInfoCount(tenant);
        if (totalCount > pageSize * (pageCount = totalCount / pageSize)) {
            ++pageCount;
        }
        if (pageNo > pageCount) {
            return null;
        }
        Page<ConfigKey> page = new Page<ConfigKey>();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(totalCount);
        try {
            List result = this.jt.query(select, new Object[]{this.generateLikeArgument(tenantTmp), (pageNo - 1) * pageSize, pageSize}, (RowMapper)CONFIG_KEY_ROW_MAPPER);
            for (ConfigKey item : result) {
                page.getPageItems().add(item);
            }
            return page;
        }
        catch (EmptyResultDataAccessException e) {
            return page;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Deprecated
    public Page<ConfigInfoBase> findAllConfigInfoBase(int pageNo, int pageSize) {
        String sqlCountRows = "SELECT COUNT(*) FROM config_info";
        String sqlFetchRows = " SELECT t.id,data_id,group_id,content,md5  FROM (                                  SELECT id FROM config_info            ORDER BY id LIMIT ?,?              ) g, config_info t                    WHERE g.id = t.id                    ";
        PaginationHelper<ConfigInfoBase> helper = new PaginationHelper<ConfigInfoBase>();
        try {
            return helper.fetchPageLimit(this.jt, sqlCountRows, sqlFetchRows, new Object[]{(pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, CONFIG_INFO_BASE_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigInfoWrapper> findAllConfigInfoForDumpAll(int pageNo, int pageSize) {
        String sqlCountRows = "select count(*) from config_info";
        String sqlFetchRows = " SELECT t.id,data_id,group_id,tenant_id,app_name,content,md5,gmt_modified  FROM (                                  SELECT id FROM config_info            ORDER BY id LIMIT ?,?              ) g, config_info t                    WHERE g.id = t.id                    ";
        PaginationHelper<ConfigInfoWrapper> helper = new PaginationHelper<ConfigInfoWrapper>();
        ArrayList params = new ArrayList();
        try {
            return helper.fetchPageLimit(this.jt, sqlCountRows, sqlFetchRows, params.toArray(), pageNo, pageSize, CONFIG_INFO_WRAPPER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigInfoWrapper> findAllConfigInfoFragment(long lastMaxId, int pageSize) {
        String select = "SELECT id,data_id,group_id,tenant_id,app_name,content,md5,gmt_modified from config_info where id > ? order by id asc limit ?,?";
        PaginationHelper<ConfigInfoWrapper> helper = new PaginationHelper<ConfigInfoWrapper>();
        try {
            return helper.fetchPageLimit(this.jt, select, new Object[]{lastMaxId, 0, pageSize}, 1, pageSize, CONFIG_INFO_WRAPPER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigInfoBetaWrapper> findAllConfigInfoBetaForDumpAll(int pageNo, int pageSize) {
        String sqlCountRows = "SELECT COUNT(*) FROM config_info_beta";
        String sqlFetchRows = " SELECT t.id,data_id,group_id,tenant_id,app_name,content,md5,gmt_modified,beta_ips  FROM (                                  SELECT id FROM config_info_beta            ORDER BY id LIMIT ?,?              ) g, config_info_beta t                    WHERE g.id = t.id                    ";
        PaginationHelper<ConfigInfoBetaWrapper> helper = new PaginationHelper<ConfigInfoBetaWrapper>();
        try {
            return helper.fetchPageLimit(this.jt, sqlCountRows, sqlFetchRows, new Object[]{(pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, CONFIG_INFO_BETA_WRAPPER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigInfoTagWrapper> findAllConfigInfoTagForDumpAll(int pageNo, int pageSize) {
        String sqlCountRows = "SELECT COUNT(*) FROM config_info_tag";
        String sqlFetchRows = " SELECT t.id,data_id,group_id,tenant_id,tag_id,app_name,content,md5,gmt_modified  FROM (                                  SELECT id FROM config_info_tag            ORDER BY id LIMIT ?,?              ) g, config_info_tag t                    WHERE g.id = t.id                    ";
        PaginationHelper<ConfigInfoTagWrapper> helper = new PaginationHelper<ConfigInfoTagWrapper>();
        try {
            return helper.fetchPageLimit(this.jt, sqlCountRows, sqlFetchRows, new Object[]{(pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, CONFIG_INFO_TAG_WRAPPER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public List<ConfigInfo> findConfigInfoByBatch(List<String> dataIds, String group, String tenant, int subQueryLimit) {
        String tenantTmp;
        String string = tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        if (CollectionUtils.isEmpty(dataIds)) {
            return Collections.emptyList();
        }
        if (subQueryLimit > 50) {
            subQueryLimit = 50;
        }
        ArrayList<ConfigInfo> result = new ArrayList<ConfigInfo>(dataIds.size());
        String sqlStart = "select data_id, group_id, tenant_id, app_name, content from config_info where group_id = ? and tenant_id = ? and data_id in (";
        String sqlEnd = ")";
        StringBuilder subQuerySql = new StringBuilder();
        for (int i = 0; i < dataIds.size(); i += subQueryLimit) {
            ArrayList<String> params = new ArrayList<String>(dataIds.subList(i, i + subQueryLimit < dataIds.size() ? i + subQueryLimit : dataIds.size()));
            for (int j = 0; j < params.size(); ++j) {
                subQuerySql.append("?");
                if (j == params.size() - 1) continue;
                subQuerySql.append(",");
            }
            params.add(0, group);
            params.add(1, tenantTmp);
            List r = this.jt.query(sqlStart + subQuerySql.toString() + sqlEnd, params.toArray(), (RowMapper)CONFIG_INFO_ROW_MAPPER);
            if (r == null || r.size() <= 0) continue;
            result.addAll(r);
        }
        return result;
    }

    public Page<ConfigInfo> findConfigInfoLike(int pageNo, int pageSize, String dataId, String group, String tenant, String appName, String content) {
        String tenantTmp;
        String string = tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        if (StringUtils.isBlank((String)dataId) && StringUtils.isBlank((String)group)) {
            if (StringUtils.isBlank((String)appName)) {
                return this.findAllConfigInfo(pageNo, pageSize, tenantTmp);
            }
            return this.findConfigInfoByApp(pageNo, pageSize, tenantTmp, appName);
        }
        PaginationHelper<ConfigInfo> helper = new PaginationHelper<ConfigInfo>();
        String sqlCountRows = "select count(*) from config_info where ";
        String sqlFetchRows = "select ID,data_id,group_id,tenant_id,app_name,content from config_info where ";
        String where = " 1=1 ";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isBlank((String)dataId)) {
            where = where + " and data_id like ? ";
            params.add(this.generateLikeArgument(dataId));
        }
        if (!StringUtils.isBlank((String)group)) {
            where = where + " and group_id like ? ";
            params.add(this.generateLikeArgument(group));
        }
        where = where + " and tenant_id like ? ";
        params.add(this.generateLikeArgument(tenantTmp));
        if (!StringUtils.isBlank((String)appName)) {
            where = where + " and app_name = ? ";
            params.add(appName);
        }
        if (!StringUtils.isBlank((String)content)) {
            where = where + " and content like ? ";
            params.add(this.generateLikeArgument(content));
        }
        try {
            return helper.fetchPage(this.jt, sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigInfo> findConfigInfoLike4Page(int pageNo, int pageSize, String dataId, String group, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("appName");
        String content = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("content");
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        PaginationHelper<ConfigInfo> helper = new PaginationHelper<ConfigInfo>();
        String sqlCountRows = "select count(*) from config_info";
        String sqlFetchRows = "select ID,data_id,group_id,tenant_id,app_name,content from config_info";
        StringBuilder where = new StringBuilder(" where ");
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.generateLikeArgument(tenantTmp));
        if (StringUtils.isNotBlank((String)configTags)) {
            sqlCountRows = "select count(*) from config_info  a left join config_tags_relation b on a.id=b.id ";
            sqlFetchRows = "select a.ID,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content from config_info  a left join config_tags_relation b on a.id=b.id ";
            where.append(" a.tenant_id like ? ");
            if (!StringUtils.isBlank((String)dataId)) {
                where.append(" and a.data_id like ? ");
                params.add(this.generateLikeArgument(dataId));
            }
            if (!StringUtils.isBlank((String)group)) {
                where.append(" and a.group_id like ? ");
                params.add(this.generateLikeArgument(group));
            }
            if (!StringUtils.isBlank((String)appName)) {
                where.append(" and a.app_name = ? ");
                params.add(appName);
            }
            if (!StringUtils.isBlank((String)content)) {
                where.append(" and a.content like ? ");
                params.add(this.generateLikeArgument(content));
            }
            where.append(" and b.tag_name in (");
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                if (i != 0) {
                    where.append(", ");
                }
                where.append("?");
                params.add(tagArr[i]);
            }
            where.append(") ");
        } else {
            where.append(" tenant_id like ? ");
            if (!StringUtils.isBlank((String)dataId)) {
                where.append(" and data_id like ? ");
                params.add(this.generateLikeArgument(dataId));
            }
            if (!StringUtils.isBlank((String)group)) {
                where.append(" and group_id like ? ");
                params.add(this.generateLikeArgument(group));
            }
            if (!StringUtils.isBlank((String)appName)) {
                where.append(" and app_name = ? ");
                params.add(appName);
            }
            if (!StringUtils.isBlank((String)content)) {
                where.append(" and content like ? ");
                params.add(this.generateLikeArgument(content));
            }
        }
        try {
            return helper.fetchPage(this.jt, sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigInfo> findConfigInfoLike(int pageNo, int pageSize, ConfigKey[] configKeys, boolean blacklist) {
        String sqlCountRows = "select count(*) from config_info where ";
        String sqlFetchRows = "select ID,data_id,group_id,tenant_id,app_name,content from config_info where ";
        String where = " 1=1 ";
        if (configKeys.length == 0 && !blacklist) {
            Page<ConfigInfo> page = new Page<ConfigInfo>();
            page.setTotalCount(0);
            return page;
        }
        PaginationHelper<ConfigInfo> helper = new PaginationHelper<ConfigInfo>();
        ArrayList<String> params = new ArrayList<String>();
        boolean isFirst = true;
        for (ConfigKey configInfo : configKeys) {
            boolean isFirstSub;
            String dataId = configInfo.getDataId();
            String group = configInfo.getGroup();
            String appName = configInfo.getAppName();
            if (StringUtils.isBlank((String)dataId) && StringUtils.isBlank((String)group) && StringUtils.isBlank((String)appName)) break;
            if (blacklist) {
                if (isFirst) {
                    isFirst = false;
                    where = where + " and ";
                } else {
                    where = where + " and ";
                }
                where = where + "(";
                isFirstSub = true;
                if (!StringUtils.isBlank((String)dataId)) {
                    where = where + " data_id not like ? ";
                    params.add(this.generateLikeArgument(dataId));
                    isFirstSub = false;
                }
                if (!StringUtils.isBlank((String)group)) {
                    if (!isFirstSub) {
                        where = where + " or ";
                    }
                    where = where + " group_id not like ? ";
                    params.add(this.generateLikeArgument(group));
                    isFirstSub = false;
                }
                if (!StringUtils.isBlank((String)appName)) {
                    if (!isFirstSub) {
                        where = where + " or ";
                    }
                    where = where + " app_name != ? ";
                    params.add(appName);
                    isFirstSub = false;
                }
                where = where + ") ";
                continue;
            }
            if (isFirst) {
                isFirst = false;
                where = where + " and ";
            } else {
                where = where + " or ";
            }
            where = where + "(";
            isFirstSub = true;
            if (!StringUtils.isBlank((String)dataId)) {
                where = where + " data_id like ? ";
                params.add(this.generateLikeArgument(dataId));
                isFirstSub = false;
            }
            if (!StringUtils.isBlank((String)group)) {
                if (!isFirstSub) {
                    where = where + " and ";
                }
                where = where + " group_id like ? ";
                params.add(this.generateLikeArgument(group));
                isFirstSub = false;
            }
            if (!StringUtils.isBlank((String)appName)) {
                if (!isFirstSub) {
                    where = where + " and ";
                }
                where = where + " app_name = ? ";
                params.add(appName);
                isFirstSub = false;
            }
            where = where + ") ";
        }
        try {
            return helper.fetchPage(this.jt, sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigInfoBase> findConfigInfoBaseLike(int pageNo, int pageSize, String dataId, String group, String content) throws IOException {
        if (StringUtils.isBlank((String)dataId) && StringUtils.isBlank((String)group)) {
            throw new IOException("invalid param");
        }
        PaginationHelper<ConfigInfoBase> helper = new PaginationHelper<ConfigInfoBase>();
        String sqlCountRows = "select count(*) from config_info where ";
        String sqlFetchRows = "select ID,data_id,group_id,tenant_id,content from config_info where ";
        String where = " 1=1 and tenant_id='' ";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isBlank((String)dataId)) {
            where = where + " and data_id like ? ";
            params.add(this.generateLikeArgument(dataId));
        }
        if (!StringUtils.isBlank((String)group)) {
            where = where + " and group_id like ? ";
            params.add(this.generateLikeArgument(group));
        }
        if (!StringUtils.isBlank((String)content)) {
            where = where + " and content like ? ";
            params.add(this.generateLikeArgument(content));
        }
        try {
            return helper.fetchPage(this.jt, sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, CONFIG_INFO_BASE_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public ConfigInfoAggr findSingleConfigInfoAggr(String dataId, String group, String tenant, String datumId) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        String sql = "SELECT id,data_id,group_id,tenant_id,datum_id,app_name,content FROM config_info_aggr WHERE data_id=? AND group_id=? AND tenant_id=? AND datum_id=?";
        try {
            return (ConfigInfoAggr)this.jt.queryForObject(sql, new Object[]{dataId, group, tenantTmp, datumId}, (RowMapper)CONFIG_INFO_AGGR_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LogUtil.fatalLog.error("[db-other-error]" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<ConfigInfoAggr> findConfigInfoAggr(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        String sql = "SELECT data_id,group_id,tenant_id,datum_id,app_name,content FROM config_info_aggr WHERE data_id=? AND group_id=? AND tenant_id=? ORDER BY datum_id";
        try {
            return this.jt.query(sql, new Object[]{dataId, group, tenantTmp}, (RowMapper)CONFIG_INFO_AGGR_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
        catch (EmptyResultDataAccessException e) {
            return Collections.emptyList();
        }
        catch (Exception e) {
            LogUtil.fatalLog.error("[db-other-error]" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Page<ConfigInfoAggr> findConfigInfoAggrByPage(String dataId, String group, String tenant, int pageNo, int pageSize) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        String sqlCountRows = "SELECT COUNT(*) FROM config_info_aggr WHERE data_id = ? and group_id = ? and tenant_id = ?";
        String sqlFetchRows = "select data_id,group_id,tenant_id,datum_id,app_name,content from config_info_aggr where data_id=? and group_id=? and tenant_id=? order by datum_id limit ?,?";
        PaginationHelper<ConfigInfoAggr> helper = new PaginationHelper<ConfigInfoAggr>();
        try {
            return helper.fetchPageLimit(this.jt, sqlCountRows, new Object[]{dataId, group, tenantTmp}, sqlFetchRows, new Object[]{dataId, group, tenantTmp, (pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, CONFIG_INFO_AGGR_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigInfoAggr> findConfigInfoAggrLike(int pageNo, int pageSize, ConfigKey[] configKeys, boolean blacklist) {
        String sqlCountRows = "select count(*) from config_info_aggr where ";
        String sqlFetchRows = "select data_id,group_id,tenant_id,datum_id,app_name,content from config_info_aggr where ";
        String where = " 1=1 ";
        if (configKeys.length == 0 && !blacklist) {
            Page<ConfigInfoAggr> page = new Page<ConfigInfoAggr>();
            page.setTotalCount(0);
            return page;
        }
        PaginationHelper<ConfigInfoAggr> helper = new PaginationHelper<ConfigInfoAggr>();
        ArrayList<String> params = new ArrayList<String>();
        boolean isFirst = true;
        for (ConfigKey configInfoAggr : configKeys) {
            boolean isFirstSub;
            String dataId = configInfoAggr.getDataId();
            String group = configInfoAggr.getGroup();
            String appName = configInfoAggr.getAppName();
            if (StringUtils.isBlank((String)dataId) && StringUtils.isBlank((String)group) && StringUtils.isBlank((String)appName)) break;
            if (blacklist) {
                if (isFirst) {
                    isFirst = false;
                    where = where + " and ";
                } else {
                    where = where + " and ";
                }
                where = where + "(";
                isFirstSub = true;
                if (!StringUtils.isBlank((String)dataId)) {
                    where = where + " data_id not like ? ";
                    params.add(this.generateLikeArgument(dataId));
                    isFirstSub = false;
                }
                if (!StringUtils.isBlank((String)group)) {
                    if (!isFirstSub) {
                        where = where + " or ";
                    }
                    where = where + " group_id not like ? ";
                    params.add(this.generateLikeArgument(group));
                    isFirstSub = false;
                }
                if (!StringUtils.isBlank((String)appName)) {
                    if (!isFirstSub) {
                        where = where + " or ";
                    }
                    where = where + " app_name != ? ";
                    params.add(appName);
                    isFirstSub = false;
                }
                where = where + ") ";
                continue;
            }
            if (isFirst) {
                isFirst = false;
                where = where + " and ";
            } else {
                where = where + " or ";
            }
            where = where + "(";
            isFirstSub = true;
            if (!StringUtils.isBlank((String)dataId)) {
                where = where + " data_id like ? ";
                params.add(this.generateLikeArgument(dataId));
                isFirstSub = false;
            }
            if (!StringUtils.isBlank((String)group)) {
                if (!isFirstSub) {
                    where = where + " and ";
                }
                where = where + " group_id like ? ";
                params.add(this.generateLikeArgument(group));
                isFirstSub = false;
            }
            if (!StringUtils.isBlank((String)appName)) {
                if (!isFirstSub) {
                    where = where + " and ";
                }
                where = where + " app_name = ? ";
                params.add(appName);
                isFirstSub = false;
            }
            where = where + ") ";
        }
        try {
            Page<ConfigInfoAggr> result = helper.fetchPage(this.jt, sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, CONFIG_INFO_AGGR_ROW_MAPPER);
            return result;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public List<ConfigInfoChanged> findAllAggrGroup() {
        String sql = "SELECT DISTINCT data_id, group_id, tenant_id FROM config_info_aggr";
        try {
            return this.jt.query(sql, new Object[0], (RowMapper)CONFIG_INFO_CHANGED_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (Exception e) {
            LogUtil.fatalLog.error("[db-other-error]" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<String> findDatumIdByContent(String dataId, String groupId, String content) {
        String sql = "SELECT datum_id FROM config_info_aggr WHERE data_id = ? AND group_id = ? AND content = ? ";
        try {
            return this.jt.queryForList(sql, new Object[]{dataId, groupId, content}, String.class);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public List<ConfigInfoWrapper> findChangeConfig(Timestamp startTime, Timestamp endTime) {
        try {
            List list = this.jt.queryForList("SELECT data_id, group_id, tenant_id, app_name, content, gmt_modified FROM config_info WHERE gmt_modified >=? AND gmt_modified <= ?", new Object[]{startTime, endTime});
            return this.convertChangeConfig(list);
        }
        catch (DataAccessException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigInfoWrapper> findChangeConfig(String dataId, String group, String tenant, String appName, Timestamp startTime, Timestamp endTime, int pageNo, int pageSize, long lastMaxId) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        String sqlCountRows = "select count(*) from config_info where ";
        String sqlFetchRows = "select id,data_id,group_id,tenant_id,app_name,content,md5,gmt_modified from config_info where ";
        String where = " 1=1 ";
        ArrayList<Object> params = new ArrayList<Object>();
        if (!StringUtils.isBlank((String)dataId)) {
            where = where + " and data_id like ? ";
            params.add(this.generateLikeArgument(dataId));
        }
        if (!StringUtils.isBlank((String)group)) {
            where = where + " and group_id like ? ";
            params.add(this.generateLikeArgument(group));
        }
        if (!StringUtils.isBlank((String)tenantTmp)) {
            where = where + " and tenant_id = ? ";
            params.add(tenantTmp);
        }
        if (!StringUtils.isBlank((String)appName)) {
            where = where + " and app_name = ? ";
            params.add(appName);
        }
        if (startTime != null) {
            where = where + " and gmt_modified >=? ";
            params.add(startTime);
        }
        if (endTime != null) {
            where = where + " and gmt_modified <=? ";
            params.add(endTime);
        }
        PaginationHelper<ConfigInfoWrapper> helper = new PaginationHelper<ConfigInfoWrapper>();
        try {
            return helper.fetchPage(this.jt, sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, lastMaxId, CONFIG_INFO_WRAPPER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public List<ConfigInfo> findDeletedConfig(Timestamp startTime, Timestamp endTime) {
        try {
            List list = this.jt.queryForList("SELECT DISTINCT data_id, group_id, tenant_id FROM his_config_info WHERE op_type = 'D' AND gmt_modified >=? AND gmt_modified <= ?", new Object[]{startTime, endTime});
            return this.convertDeletedConfig(list);
        }
        catch (DataAccessException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    private long addConfigInfoAtomic(final String srcIp, final String srcUser, final ConfigInfo configInfo, final Timestamp time, Map<String, Object> configAdvanceInfo) {
        final String appNameTmp = StringUtils.isBlank((String)configInfo.getAppName()) ? "" : configInfo.getAppName();
        final String tenantTmp = StringUtils.isBlank((String)configInfo.getTenant()) ? "" : configInfo.getTenant();
        final String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        final String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        final String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        final String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        final String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        final String md5Tmp = MD5.getInstance().getMD5String(configInfo.getContent());
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        String sql = "INSERT INTO config_info(data_id,group_id,tenant_id,app_name,content,md5,src_ip,src_user,gmt_create,gmt_modified,c_desc,c_use,effect,type,c_schema) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try {
            this.jt.update(new PreparedStatementCreator(){

                @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION_EXCEPTION_EDGE", "SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="findbugs does not trust jdbctemplate, sql is constant in practice")
                public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                    PreparedStatement ps = connection.prepareStatement("INSERT INTO config_info(data_id,group_id,tenant_id,app_name,content,md5,src_ip,src_user,gmt_create,gmt_modified,c_desc,c_use,effect,type,c_schema) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", 1);
                    ps.setString(1, configInfo.getDataId());
                    ps.setString(2, configInfo.getGroup());
                    ps.setString(3, tenantTmp);
                    ps.setString(4, appNameTmp);
                    ps.setString(5, configInfo.getContent());
                    ps.setString(6, md5Tmp);
                    ps.setString(7, srcIp);
                    ps.setString(8, srcUser);
                    ps.setTimestamp(9, time);
                    ps.setTimestamp(10, time);
                    ps.setString(11, desc);
                    ps.setString(12, use);
                    ps.setString(13, effect);
                    ps.setString(14, type);
                    ps.setString(15, schema);
                    return ps;
                }
            }, (KeyHolder)keyHolder);
            Number nu = keyHolder.getKey();
            if (nu == null) {
                throw new IllegalArgumentException("insert config_info fail");
            }
            return nu.longValue();
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public void addConfiTagRelationAtomic(long configId, String tagName, String dataId, String group, String tenant) {
        try {
            this.jt.update("INSERT INTO config_tags_relation(id,tag_name,tag_type,data_id,group_id,tenant_id) VALUES(?,?,?,?,?,?)", new Object[]{configId, tagName, null, dataId, group, tenant});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public void addConfiTagsRelationAtomic(long configId, String configTags, String dataId, String group, String tenant) {
        if (StringUtils.isNotBlank((String)configTags)) {
            String[] tagArr;
            for (String tag : tagArr = configTags.split(",")) {
                this.addConfiTagRelationAtomic(configId, tag, dataId, group, tenant);
            }
        }
    }

    public void removeTagByIdAtomic(long id) {
        try {
            this.jt.update("DELETE FROM config_tags_relation WHERE id=?", new Object[]{id});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public List<String> getConfigTagsByTenant(String tenant) {
        String sql = "SELECT tag_name FROM config_tags_relation WHERE tenant_id = ? ";
        try {
            return this.jt.queryForList(sql, new Object[]{tenant}, String.class);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public List<String> selectTagByConfig(String dataId, String group, String tenant) {
        String sql = "SELECT tag_name FROM config_tags_relation WHERE data_id=? AND group_id=? AND tenant_id = ? ";
        try {
            return this.jt.queryForList(sql, new Object[]{dataId, group, tenant}, String.class);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    private void removeConfigInfoAtomic(String dataId, String group, String tenant, String srcIp, String srcUser) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        try {
            this.jt.update("DELETE FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, tenantTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public void removeConfigInfoTag(String dataId, String group, String tenant, String tag, String srcIp, String srcUser) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        String tagTmp = StringUtils.isBlank((String)tag) ? "" : tag;
        try {
            this.jt.update("DELETE FROM config_info_tag WHERE data_id=? AND group_id=? AND tenant_id=? AND tag_id=?", new Object[]{dataId, group, tenantTmp, tagTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    private void updateConfigInfoAtomic(ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, Map<String, Object> configAdvanceInfo) {
        String appNameTmp = StringUtils.isBlank((String)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((String)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String md5Tmp = MD5.getInstance().getMD5String(configInfo.getContent());
        String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        try {
            this.jt.update("UPDATE config_info SET content=?, md5 = ?, src_ip=?,src_user=?,gmt_modified=?,app_name=?,c_desc=?,c_use=?,effect=?,type=?,c_schema=? WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{configInfo.getContent(), md5Tmp, srcIp, srcUser, time, appNameTmp, desc, use, effect, type, schema, configInfo.getDataId(), configInfo.getGroup(), tenantTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public ConfigInfo findConfigInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        try {
            return (ConfigInfo)this.jt.queryForObject("SELECT ID,data_id,group_id,tenant_id,app_name,content,md5 FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, tenantTmp}, (RowMapper)CONFIG_INFO_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public ConfigAdvanceInfo findConfigAdvanceInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        try {
            List<String> configTagList = this.selectTagByConfig(dataId, group, tenant);
            ConfigAdvanceInfo configAdvance = (ConfigAdvanceInfo)this.jt.queryForObject("SELECT gmt_create,gmt_modified,src_user,src_ip,c_desc,c_use,effect,type,c_schema FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, tenantTmp}, (RowMapper)CONFIG_ADVANCE_INFO_ROW_MAPPER);
            if (configTagList != null && !configTagList.isEmpty()) {
                StringBuilder configTagsTmp = new StringBuilder();
                for (String configTag : configTagList) {
                    if (configTagsTmp.length() == 0) {
                        configTagsTmp.append(configTag);
                        continue;
                    }
                    configTagsTmp.append(",").append(configTag);
                }
                configAdvance.setConfigTags(configTagsTmp.toString());
            }
            return configAdvance;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public ConfigAllInfo findConfigAllInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        try {
            List<String> configTagList = this.selectTagByConfig(dataId, group, tenant);
            ConfigAllInfo configAdvance = (ConfigAllInfo)this.jt.queryForObject("SELECT ID,data_id,group_id,tenant_id,app_name,content,md5,gmt_create,gmt_modified,src_user,src_ip,c_desc,c_use,effect,type,c_schema FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, tenantTmp}, (RowMapper)CONFIG_ALL_INFO_ROW_MAPPER);
            if (configTagList != null && !configTagList.isEmpty()) {
                StringBuilder configTagsTmp = new StringBuilder();
                for (String configTag : configTagList) {
                    if (configTagsTmp.length() == 0) {
                        configTagsTmp.append(configTag);
                        continue;
                    }
                    configTagsTmp.append(",").append(configTag);
                }
                configAdvance.setConfigTags(configTagsTmp.toString());
            }
            return configAdvance;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    private void insertConfigHistoryAtomic(long id, ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, String ops) {
        String appNameTmp = StringUtils.isBlank((String)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((String)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String md5Tmp = MD5.getInstance().getMD5String(configInfo.getContent());
        try {
            this.jt.update("INSERT INTO his_config_info (id,data_id,group_id,tenant_id,app_name,content,md5,src_ip,src_user,gmt_modified,op_type) VALUES(?,?,?,?,?,?,?,?,?,?,?)", new Object[]{id, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, appNameTmp, configInfo.getContent(), md5Tmp, srcIp, srcUser, time, ops});
        }
        catch (DataAccessException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public Page<ConfigHistoryInfo> findConfigHistory(String dataId, String group, String tenant, int pageNo, int pageSize) {
        PaginationHelper<ConfigHistoryInfo> helper = new PaginationHelper<ConfigHistoryInfo>();
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        String sqlCountRows = "select count(*) from his_config_info where data_id = ? and group_id = ? and tenant_id = ?";
        String sqlFetchRows = "select nid,data_id,group_id,tenant_id,app_name,src_ip,op_type,gmt_create,gmt_modified from his_config_info where data_id = ? and group_id = ? and tenant_id = ? order by nid desc";
        Page<ConfigHistoryInfo> page = null;
        try {
            page = helper.fetchPage(this.jt, sqlCountRows, sqlFetchRows, new Object[]{dataId, group, tenantTmp}, pageNo, pageSize, HISTORY_LIST_ROW_MAPPER);
        }
        catch (DataAccessException e) {
            LogUtil.fatalLog.error("[list-config-history] error, dataId:{}, group:{}", (Object)new Object[]{dataId, group}, (Object)e);
            throw e;
        }
        return page;
    }

    private void addConfigSubAtomic(String dataId, String group, String appName, Timestamp date) {
        String appNameTmp = appName == null ? "" : appName;
        try {
            this.jt.update("INSERT INTO app_configdata_relation_subs(data_id,group_id,app_name,gmt_modified) VALUES(?,?,?,?)", new Object[]{dataId, group, appNameTmp, date});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    private void updateConfigSubAtomic(String dataId, String group, String appName, Timestamp time) {
        String appNameTmp = appName == null ? "" : appName;
        try {
            this.jt.update("UPDATE app_configdata_relation_subs SET gmt_modified=? WHERE data_id=? AND group_id=? AND app_name=?", new Object[]{time, dataId, group, appNameTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public ConfigHistoryInfo detailConfigHistory(Long nid) {
        String sqlFetchRows = "SELECT nid,data_id,group_id,tenant_id,app_name,content,md5,src_user,src_ip,op_type,gmt_create,gmt_modified FROM his_config_info WHERE nid = ?";
        try {
            ConfigHistoryInfo historyInfo = (ConfigHistoryInfo)this.jt.queryForObject(sqlFetchRows, new Object[]{nid}, (RowMapper)HISTORY_DETAIL_ROW_MAPPER);
            return historyInfo;
        }
        catch (DataAccessException e) {
            LogUtil.fatalLog.error("[list-config-history] error, nid:{}", (Object)new Object[]{nid}, (Object)e);
            throw e;
        }
    }

    public void insertTenantInfoAtomic(String kp, String tenantId, String tenantName, String tenantDesc, String createResoure, long time) {
        try {
            this.jt.update("INSERT INTO tenant_info(kp,tenant_id,tenant_name,tenant_desc,create_source,gmt_create,gmt_modified) VALUES(?,?,?,?,?,?,?)", new Object[]{kp, tenantId, tenantName, tenantDesc, createResoure, time, time});
        }
        catch (DataAccessException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public void updateTenantNameAtomic(String kp, String tenantId, String tenantName, String tenantDesc) {
        try {
            this.jt.update("UPDATE tenant_info SET tenant_name = ?, tenant_desc = ?, gmt_modified= ? WHERE kp=? AND tenant_id=?", new Object[]{tenantName, tenantDesc, System.currentTimeMillis(), kp, tenantId});
        }
        catch (DataAccessException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public List<TenantInfo> findTenantByKp(String kp) {
        String sql = "SELECT tenant_id,tenant_name,tenant_desc FROM tenant_info WHERE kp=?";
        try {
            return this.jt.query(sql, new Object[]{kp}, (RowMapper)TENANT_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
        catch (EmptyResultDataAccessException e) {
            return Collections.emptyList();
        }
        catch (Exception e) {
            LogUtil.fatalLog.error("[db-other-error]" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public TenantInfo findTenantByKp(String kp, String tenantId) {
        String sql = "SELECT tenant_id,tenant_name,tenant_desc FROM tenant_info WHERE kp=? AND tenant_id=?";
        try {
            return (TenantInfo)this.jt.queryForObject(sql, new Object[]{kp, tenantId}, (RowMapper)TENANT_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (Exception e) {
            LogUtil.fatalLog.error("[db-other-error]" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void removeTenantInfoAtomic(String kp, String tenantId) {
        try {
            this.jt.update("DELETE FROM tenant_info WHERE kp=? AND tenant_id=?", new Object[]{kp, tenantId});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public User findUserByUsername(String username) {
        String sql = "SELECT username,password FROM users WHERE username=? ";
        try {
            return (User)this.jt.queryForObject(sql, new Object[]{username}, (RowMapper)USER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (Exception e) {
            LogUtil.fatalLog.error("[db-other-error]" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private List<ConfigInfo> convertDeletedConfig(List<Map<String, Object>> list) {
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        for (Map<String, Object> map : list) {
            String dataId = (String)map.get("data_id");
            String group = (String)map.get("group_id");
            String tenant = (String)map.get("tenant_id");
            ConfigInfo config = new ConfigInfo();
            config.setDataId(dataId);
            config.setGroup(group);
            config.setTenant(tenant);
            configs.add(config);
        }
        return configs;
    }

    private List<ConfigInfoWrapper> convertChangeConfig(List<Map<String, Object>> list) {
        ArrayList<ConfigInfoWrapper> configs = new ArrayList<ConfigInfoWrapper>();
        for (Map<String, Object> map : list) {
            String dataId = (String)map.get("data_id");
            String group = (String)map.get("group_id");
            String tenant = (String)map.get("tenant_id");
            String content = (String)map.get("content");
            long mTime = ((Timestamp)map.get("gmt_modified")).getTime();
            ConfigInfoWrapper config = new ConfigInfoWrapper();
            config.setDataId(dataId);
            config.setGroup(group);
            config.setTenant(tenant);
            config.setContent(content);
            config.setLastModified(mTime);
            configs.add(config);
        }
        return configs;
    }

    public List<ConfigInfoWrapper> listAllGroupKeyMd5() {
        int pageSize = 10000;
        int totalCount = this.configInfoCount();
        int pageCount = (int)Math.ceil((double)totalCount * 1.0 / 10000.0);
        ArrayList<ConfigInfoWrapper> allConfigInfo = new ArrayList<ConfigInfoWrapper>();
        for (int pageNo = 1; pageNo <= pageCount; ++pageNo) {
            List<ConfigInfoWrapper> configInfoList = this.listGroupKeyMd5ByPage(pageNo, 10000);
            allConfigInfo.addAll(configInfoList);
        }
        return allConfigInfo;
    }

    private List<ConfigInfoWrapper> listGroupKeyMd5ByPage(int pageNo, int pageSize) {
        String sqlCountRows = " SELECT COUNT(*) FROM config_info ";
        String sqlFetchRows = " SELECT t.id,data_id,group_id,tenant_id,app_name,md5,gmt_modified FROM ( SELECT id FROM config_info ORDER BY id LIMIT ?,?  ) g, config_info t WHERE g.id = t.id";
        PaginationHelper<ConfigInfoWrapper> helper = new PaginationHelper<ConfigInfoWrapper>();
        try {
            Page<ConfigInfoWrapper> page = helper.fetchPageLimit(this.jt, sqlCountRows, sqlFetchRows, new Object[]{(pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, CONFIG_INFO_WRAPPER_ROW_MAPPER);
            return page.getPageItems();
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    private String generateLikeArgument(String s) {
        String fuzzySearchSign = "\\*";
        String sqlLikePercentSign = "%";
        if (s.contains(PATTERN_STR)) {
            return s.replaceAll(fuzzySearchSign, sqlLikePercentSign);
        }
        return s;
    }

    public ConfigInfoWrapper queryConfigInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((String)tenant) ? "" : tenant;
        try {
            return (ConfigInfoWrapper)this.jt.queryForObject("SELECT ID,data_id,group_id,tenant_id,app_name,content,gmt_modified,md5 FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, tenantTmp}, (RowMapper)CONFIG_INFO_WRAPPER_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    public boolean isExistTable(String tableName) {
        String sql = "SELECT COUNT(*) FROM " + tableName;
        try {
            this.jt.queryForObject(sql, Integer.class);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public Boolean completeMd5() {
        LogUtil.defaultLog.info("[start completeMd5]");
        int perPageSize = 1000;
        int rowCount = this.configInfoCount();
        int pageCount = (int)Math.ceil((double)rowCount * 1.0 / (double)perPageSize);
        int actualRowCount = 0;
        for (int pageNo = 1; pageNo <= pageCount; ++pageNo) {
            Page<ConfigInfoWrapper> page = this.findAllConfigInfoForDumpAll(pageNo, perPageSize);
            if (page == null) continue;
            for (ConfigInfoWrapper cf : page.getPageItems()) {
                String md5InDb = cf.getMd5();
                String content = cf.getContent();
                String tenant = cf.getTenant();
                String md5 = MD5.getInstance().getMD5String(content);
                if (StringUtils.isBlank((String)md5InDb)) {
                    try {
                        this.updateMd5(cf.getDataId(), cf.getGroup(), tenant, md5, new Timestamp(cf.getLastModified()));
                    }
                    catch (Exception e) {
                        LogUtil.defaultLog.error("[completeMd5-error] datId:{} group:{} lastModified:{}", new Object[]{cf.getDataId(), cf.getGroup(), new Timestamp(cf.getLastModified())});
                    }
                    continue;
                }
                if (md5InDb.equals(md5)) continue;
                try {
                    this.updateMd5(cf.getDataId(), cf.getGroup(), tenant, md5, new Timestamp(cf.getLastModified()));
                }
                catch (Exception e) {
                    LogUtil.defaultLog.error("[completeMd5-error] datId:{} group:{} lastModified:{}", new Object[]{cf.getDataId(), cf.getGroup(), new Timestamp(cf.getLastModified())});
                }
            }
            LogUtil.defaultLog.info("[completeMd5] {} / {}", (Object)(actualRowCount += page.getPageItems().size()), (Object)rowCount);
        }
        return true;
    }

    public static class ConfigInfoTagWrapper
    extends ConfigInfo4Tag {
        private static final long serialVersionUID = 4511997359365712505L;
        private long lastModified;

        public long getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }

    public static class ConfigInfoBetaWrapper
    extends ConfigInfo4Beta {
        private static final long serialVersionUID = 4511997359365712505L;
        private long lastModified;

        public long getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }

    public static class ConfigInfoWrapper
    extends ConfigInfo {
        private static final long serialVersionUID = 4511997359365712505L;
        private long lastModified;

        public long getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }

    static final class UserRowMapper
    implements RowMapper<User> {
        UserRowMapper() {
        }

        public User mapRow(ResultSet rs, int rowNum) throws SQLException {
            User user = new User();
            user.setUsername(rs.getString("username"));
            user.setPassword(rs.getString("password"));
            return user;
        }
    }

    static final class TenantInfoRowMapper
    implements RowMapper<TenantInfo> {
        TenantInfoRowMapper() {
        }

        public TenantInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
            TenantInfo info = new TenantInfo();
            info.setTenantId(rs.getString("tenant_id"));
            info.setTenantName(rs.getString("tenant_name"));
            info.setTenantDesc(rs.getString("tenant_desc"));
            return info;
        }
    }

    static final class ConfigHistoryDetailRowMapper
    implements RowMapper<ConfigHistoryInfo> {
        ConfigHistoryDetailRowMapper() {
        }

        public ConfigHistoryInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
            ConfigHistoryInfo configHistoryInfo = new ConfigHistoryInfo();
            configHistoryInfo.setId(rs.getLong("nid"));
            configHistoryInfo.setDataId(rs.getString("data_id"));
            configHistoryInfo.setGroup(rs.getString("group_id"));
            configHistoryInfo.setTenant(rs.getString("tenant_id"));
            configHistoryInfo.setAppName(rs.getString("app_name"));
            configHistoryInfo.setMd5(rs.getString("md5"));
            configHistoryInfo.setContent(rs.getString("content"));
            configHistoryInfo.setSrcUser(rs.getString("src_user"));
            configHistoryInfo.setSrcIp(rs.getString("src_ip"));
            configHistoryInfo.setOpType(rs.getString("op_type"));
            configHistoryInfo.setCreatedTime(rs.getTimestamp("gmt_create"));
            configHistoryInfo.setLastModifiedTime(rs.getTimestamp("gmt_modified"));
            return configHistoryInfo;
        }
    }

    static final class ConfigHistoryRowMapper
    implements RowMapper<ConfigHistoryInfo> {
        ConfigHistoryRowMapper() {
        }

        public ConfigHistoryInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
            ConfigHistoryInfo configHistoryInfo = new ConfigHistoryInfo();
            configHistoryInfo.setId(rs.getLong("nid"));
            configHistoryInfo.setDataId(rs.getString("data_id"));
            configHistoryInfo.setGroup(rs.getString("group_id"));
            configHistoryInfo.setTenant(rs.getString("tenant_id"));
            configHistoryInfo.setAppName(rs.getString("app_name"));
            configHistoryInfo.setSrcIp(rs.getString("src_ip"));
            configHistoryInfo.setOpType(rs.getString("op_type"));
            configHistoryInfo.setCreatedTime(rs.getTimestamp("gmt_create"));
            configHistoryInfo.setLastModifiedTime(rs.getTimestamp("gmt_modified"));
            return configHistoryInfo;
        }
    }

    static final class ConfigInfoChangedRowMapper
    implements RowMapper<ConfigInfoChanged> {
        ConfigInfoChangedRowMapper() {
        }

        public ConfigInfoChanged mapRow(ResultSet rs, int rowNum) throws SQLException {
            ConfigInfoChanged info = new ConfigInfoChanged();
            info.setDataId(rs.getString("data_id"));
            info.setGroup(rs.getString("group_id"));
            info.setTenant(rs.getString("tenant_id"));
            return info;
        }
    }

    static final class ConfigInfoAggrRowMapper
    implements RowMapper<ConfigInfoAggr> {
        ConfigInfoAggrRowMapper() {
        }

        public ConfigInfoAggr mapRow(ResultSet rs, int rowNum) throws SQLException {
            ConfigInfoAggr info = new ConfigInfoAggr();
            info.setDataId(rs.getString("data_id"));
            info.setGroup(rs.getString("group_id"));
            info.setDatumId(rs.getString("datum_id"));
            info.setTenant(rs.getString("tenant_id"));
            info.setAppName(rs.getString("app_name"));
            info.setContent(rs.getString("content"));
            return info;
        }
    }

    static final class ConfigInfoBaseRowMapper
    implements RowMapper<ConfigInfoBase> {
        ConfigInfoBaseRowMapper() {
        }

        public ConfigInfoBase mapRow(ResultSet rs, int rowNum) throws SQLException {
            ConfigInfoBase info = new ConfigInfoBase();
            info.setDataId(rs.getString("data_id"));
            info.setGroup(rs.getString("group_id"));
            try {
                info.setContent(rs.getString("content"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                info.setId(rs.getLong("ID"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return info;
        }
    }

    static final class ConfigInfo4TagRowMapper
    implements RowMapper<ConfigInfo4Tag> {
        ConfigInfo4TagRowMapper() {
        }

        public ConfigInfo4Tag mapRow(ResultSet rs, int rowNum) throws SQLException {
            ConfigInfo4Tag info = new ConfigInfo4Tag();
            info.setDataId(rs.getString("data_id"));
            info.setGroup(rs.getString("group_id"));
            info.setTenant(rs.getString("tenant_id"));
            info.setTag(rs.getString("tag_id"));
            info.setAppName(rs.getString("app_name"));
            try {
                info.setContent(rs.getString("content"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                info.setId(rs.getLong("ID"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                info.setMd5(rs.getString("md5"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return info;
        }
    }

    static final class ConfigInfo4BetaRowMapper
    implements RowMapper<ConfigInfo4Beta> {
        ConfigInfo4BetaRowMapper() {
        }

        public ConfigInfo4Beta mapRow(ResultSet rs, int rowNum) throws SQLException {
            ConfigInfo4Beta info = new ConfigInfo4Beta();
            info.setDataId(rs.getString("data_id"));
            info.setGroup(rs.getString("group_id"));
            info.setTenant(rs.getString("tenant_id"));
            info.setAppName(rs.getString("app_name"));
            info.setBetaIps(rs.getString("beta_ips"));
            try {
                info.setContent(rs.getString("content"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                info.setId(rs.getLong("ID"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                info.setMd5(rs.getString("md5"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return info;
        }
    }

    static final class ConfigAllInfoRowMapper
    implements RowMapper<ConfigAllInfo> {
        ConfigAllInfoRowMapper() {
        }

        public ConfigAllInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
            ConfigAllInfo info = new ConfigAllInfo();
            info.setDataId(rs.getString("data_id"));
            info.setGroup(rs.getString("group_id"));
            info.setTenant(rs.getString("tenant_id"));
            info.setAppName(rs.getString("app_name"));
            try {
                info.setContent(rs.getString("content"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                info.setMd5(rs.getString("md5"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                info.setId(rs.getLong("ID"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            info.setCreateTime(rs.getTimestamp("gmt_modified").getTime());
            info.setModifyTime(rs.getTimestamp("gmt_modified").getTime());
            info.setCreateUser(rs.getString("src_user"));
            info.setCreateIp(rs.getString("src_ip"));
            info.setDesc(rs.getString("c_desc"));
            info.setUse(rs.getString("c_use"));
            info.setEffect(rs.getString("effect"));
            info.setType(rs.getString("type"));
            info.setSchema(rs.getString("c_schema"));
            return info;
        }
    }

    static final class ConfigAdvanceInfoRowMapper
    implements RowMapper<ConfigAdvanceInfo> {
        ConfigAdvanceInfoRowMapper() {
        }

        public ConfigAdvanceInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
            ConfigAdvanceInfo info = new ConfigAdvanceInfo();
            info.setCreateTime(rs.getTimestamp("gmt_modified").getTime());
            info.setModifyTime(rs.getTimestamp("gmt_modified").getTime());
            info.setCreateUser(rs.getString("src_user"));
            info.setCreateIp(rs.getString("src_ip"));
            info.setDesc(rs.getString("c_desc"));
            info.setUse(rs.getString("c_use"));
            info.setEffect(rs.getString("effect"));
            info.setType(rs.getString("type"));
            info.setSchema(rs.getString("c_schema"));
            return info;
        }
    }

    static final class ConfigKeyRowMapper
    implements RowMapper<ConfigKey> {
        ConfigKeyRowMapper() {
        }

        public ConfigKey mapRow(ResultSet rs, int rowNum) throws SQLException {
            ConfigKey info = new ConfigKey();
            info.setDataId(rs.getString("data_id"));
            info.setGroup(rs.getString("group_id"));
            info.setAppName(rs.getString("app_name"));
            return info;
        }
    }

    static final class ConfigInfoRowMapper
    implements RowMapper<ConfigInfo> {
        ConfigInfoRowMapper() {
        }

        public ConfigInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
            ConfigInfo info = new ConfigInfo();
            info.setDataId(rs.getString("data_id"));
            info.setGroup(rs.getString("group_id"));
            info.setTenant(rs.getString("tenant_id"));
            info.setAppName(rs.getString("app_name"));
            try {
                info.setContent(rs.getString("content"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                info.setMd5(rs.getString("md5"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                info.setId(rs.getLong("ID"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return info;
        }
    }

    static final class ConfigInfoTagWrapperRowMapper
    implements RowMapper<ConfigInfoTagWrapper> {
        ConfigInfoTagWrapperRowMapper() {
        }

        public ConfigInfoTagWrapper mapRow(ResultSet rs, int rowNum) throws SQLException {
            ConfigInfoTagWrapper info = new ConfigInfoTagWrapper();
            info.setDataId(rs.getString("data_id"));
            info.setGroup(rs.getString("group_id"));
            info.setTenant(rs.getString("tenant_id"));
            info.setTag(rs.getString("tag_id"));
            info.setAppName(rs.getString("app_name"));
            try {
                info.setContent(rs.getString("content"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                info.setId(rs.getLong("ID"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                info.setLastModified(rs.getTimestamp("gmt_modified").getTime());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                info.setMd5(rs.getString("md5"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return info;
        }
    }

    static final class ConfigInfoBetaWrapperRowMapper
    implements RowMapper<ConfigInfoBetaWrapper> {
        ConfigInfoBetaWrapperRowMapper() {
        }

        public ConfigInfoBetaWrapper mapRow(ResultSet rs, int rowNum) throws SQLException {
            ConfigInfoBetaWrapper info = new ConfigInfoBetaWrapper();
            info.setDataId(rs.getString("data_id"));
            info.setGroup(rs.getString("group_id"));
            info.setTenant(rs.getString("tenant_id"));
            info.setAppName(rs.getString("app_name"));
            info.setBetaIps(rs.getString("beta_ips"));
            try {
                info.setContent(rs.getString("content"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                info.setId(rs.getLong("ID"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                info.setLastModified(rs.getTimestamp("gmt_modified").getTime());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                info.setMd5(rs.getString("md5"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return info;
        }
    }

    static final class ConfigInfoWrapperRowMapper
    implements RowMapper<ConfigInfoWrapper> {
        ConfigInfoWrapperRowMapper() {
        }

        public ConfigInfoWrapper mapRow(ResultSet rs, int rowNum) throws SQLException {
            ConfigInfoWrapper info = new ConfigInfoWrapper();
            info.setDataId(rs.getString("data_id"));
            info.setGroup(rs.getString("group_id"));
            info.setTenant(rs.getString("tenant_id"));
            info.setAppName(rs.getString("app_name"));
            try {
                info.setContent(rs.getString("content"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                info.setId(rs.getLong("ID"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                info.setLastModified(rs.getTimestamp("gmt_modified").getTime());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                info.setMd5(rs.getString("md5"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return info;
        }
    }
}

