/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.config.server.model.SampleResult;
import com.alibaba.nacos.config.server.service.ServerListService;
import com.alibaba.nacos.config.server.service.notify.NotifyService;
import com.alibaba.nacos.config.server.utils.JSONUtils;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.RunningConfigUtils;
import com.alibaba.nacos.config.server.utils.ThreadUtil;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigSubService {
    private ScheduledExecutorService scheduler;
    private ServerListService serverListService;

    @Autowired
    public ConfigSubService(ServerListService serverListService1) {
        this.serverListService = serverListService1;
        this.scheduler = Executors.newScheduledThreadPool(ThreadUtil.getSuitableThreadCount(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("com.alibaba.nacos.ConfigSubService");
                return t;
            }
        });
    }

    protected ConfigSubService() {
    }

    private String getUrl(String ip, String relativePath) {
        return "http://" + ip + RunningConfigUtils.getContextPath() + relativePath;
    }

    private List<SampleResult> runCollectionJob(String url, Map<String, String> params, CompletionService<SampleResult> completionService, List<SampleResult> resultList) {
        List<String> ipList = this.serverListService.getServerList();
        ArrayList<SampleResult> collectionResult = new ArrayList<SampleResult>(ipList.size());
        for (String ip : ipList) {
            try {
                completionService.submit(new Job(ip, url, params));
            }
            catch (Exception e) {
                LogUtil.defaultLog.warn("Get client info from {} with exception: {} during submit job", (Object)ip, (Object)e.getMessage());
            }
        }
        SampleResult sampleResults = null;
        for (int i = 0; i < ipList.size(); ++i) {
            try {
                Future<SampleResult> f = completionService.poll(1000L, TimeUnit.MILLISECONDS);
                try {
                    if (f != null) {
                        sampleResults = f.get(500L, TimeUnit.MILLISECONDS);
                        if (sampleResults == null) continue;
                        collectionResult.add(sampleResults);
                        continue;
                    }
                    LogUtil.defaultLog.warn("The task in ip: {}  did not completed in 1000ms ", (Object)ipList.get(i));
                }
                catch (TimeoutException e) {
                    if (f != null) {
                        f.cancel(true);
                    }
                    LogUtil.defaultLog.warn("get task result with TimeoutException: {} ", (Object)e.getMessage());
                }
                continue;
            }
            catch (InterruptedException e) {
                LogUtil.defaultLog.warn("get task result with InterruptedException: {} ", (Object)e.getMessage());
                continue;
            }
            catch (ExecutionException e) {
                LogUtil.defaultLog.warn("get task result with ExecutionException: {} ", (Object)e.getMessage());
            }
        }
        return collectionResult;
    }

    public SampleResult mergeSampleResult(SampleResult sampleCollectResult, List<SampleResult> sampleResults) {
        SampleResult mergeResult = new SampleResult();
        Map<Object, Object> lisentersGroupkeyStatus = null;
        lisentersGroupkeyStatus = sampleCollectResult.getLisentersGroupkeyStatus() == null || sampleCollectResult.getLisentersGroupkeyStatus().isEmpty() ? new HashMap(10) : sampleCollectResult.getLisentersGroupkeyStatus();
        for (SampleResult sampleResult : sampleResults) {
            Map<String, String> lisentersGroupkeyStatusTmp = sampleResult.getLisentersGroupkeyStatus();
            for (Map.Entry<String, String> entry : lisentersGroupkeyStatusTmp.entrySet()) {
                lisentersGroupkeyStatus.put(entry.getKey(), entry.getValue());
            }
        }
        mergeResult.setLisentersGroupkeyStatus(lisentersGroupkeyStatus);
        return mergeResult;
    }

    public SampleResult getCollectSampleResult(String dataId, String group, String tenant, int sampleTime) throws Exception {
        ArrayList<SampleResult> resultList = new ArrayList<SampleResult>();
        String url = "/v1/cs/communication/configWatchers";
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put("dataId", dataId);
        params.put("group", group);
        if (!StringUtils.isBlank((CharSequence)tenant)) {
            params.put("tenant", tenant);
        }
        LinkedBlockingDeque queue = new LinkedBlockingDeque(this.serverListService.getServerList().size());
        ExecutorCompletionService<SampleResult> completionService = new ExecutorCompletionService<SampleResult>(this.scheduler, queue);
        SampleResult sampleCollectResult = new SampleResult();
        for (int i = 0; i < sampleTime; ++i) {
            List<SampleResult> sampleResults = this.runCollectionJob(url, params, completionService, resultList);
            if (sampleResults == null) continue;
            sampleCollectResult = this.mergeSampleResult(sampleCollectResult, sampleResults);
        }
        return sampleCollectResult;
    }

    public SampleResult getCollectSampleResultByIp(String ip, int sampleTime) throws Exception {
        ArrayList<SampleResult> resultList = new ArrayList<SampleResult>(10);
        String url = "/v1/cs/communication/watcherConfigs";
        HashMap<String, String> params = new HashMap<String, String>(50);
        params.put("ip", ip);
        LinkedBlockingDeque queue = new LinkedBlockingDeque(this.serverListService.getServerList().size());
        ExecutorCompletionService<SampleResult> completionService = new ExecutorCompletionService<SampleResult>(this.scheduler, queue);
        SampleResult sampleCollectResult = new SampleResult();
        for (int i = 0; i < sampleTime; ++i) {
            List<SampleResult> sampleResults = this.runCollectionJob(url, params, completionService, resultList);
            if (sampleResults == null) continue;
            sampleCollectResult = this.mergeSampleResult(sampleCollectResult, sampleResults);
        }
        return sampleCollectResult;
    }

    class Job
    implements Callable<SampleResult> {
        private String ip;
        private String url;
        private Map<String, String> params;

        public Job(String ip, String url, Map<String, String> params) {
            this.ip = ip;
            this.url = url;
            this.params = params;
        }

        @Override
        public SampleResult call() throws Exception {
            try {
                StringBuilder paramUrl = new StringBuilder();
                for (Map.Entry<String, String> param : this.params.entrySet()) {
                    paramUrl.append("&").append(param.getKey()).append("=").append(URLEncoder.encode(param.getValue(), "UTF-8"));
                }
                String urlAll = ConfigSubService.this.getUrl(this.ip, this.url) + "?" + paramUrl;
                NotifyService.HttpResult result = NotifyService.invokeURL(urlAll, null, "UTF-8");
                if (result.code == 200) {
                    String json = result.content;
                    Object resultObj = JSONUtils.deserializeObject(json, new TypeReference<SampleResult>(){});
                    return (SampleResult)resultObj;
                }
                LogUtil.defaultLog.info("Can not get clientInfo from {} with {}", (Object)this.ip, (Object)result.code);
                return null;
            }
            catch (Exception e) {
                LogUtil.defaultLog.warn("Get client info from {} with exception: {}", (Object)this.ip, (Object)e.getMessage());
                return null;
            }
        }
    }
}

