/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.monitor;

import com.alibaba.nacos.config.server.monitor.MetricsMonitor;
import com.alibaba.nacos.config.server.monitor.NotifyTaskQueueMonitorTask;
import com.alibaba.nacos.config.server.monitor.PrintGetConfigResponeTask;
import com.alibaba.nacos.config.server.monitor.PrintMemoryTask;
import com.alibaba.nacos.config.server.service.TimerTaskService;
import com.alibaba.nacos.config.server.service.notify.AsyncNotifyService;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class MemoryMonitor {
    static final long DELAY_SECONDS = 10L;

    @Autowired
    public MemoryMonitor(AsyncNotifyService notifySingleService) {
        TimerTaskService.scheduleWithFixedDelay(new PrintMemoryTask(), 10L, 10L, TimeUnit.SECONDS);
        TimerTaskService.scheduleWithFixedDelay(new PrintGetConfigResponeTask(), 10L, 10L, TimeUnit.SECONDS);
        TimerTaskService.scheduleWithFixedDelay(new NotifyTaskQueueMonitorTask(notifySingleService), 10L, 10L, TimeUnit.SECONDS);
    }

    @Scheduled(cron="0 0 0 * * ?")
    public void clear() {
        MetricsMonitor.getConfigMonitor().set(0);
        MetricsMonitor.getPublishMonitor().set(0);
    }
}

