/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.filter;

import com.alibaba.nacos.config.server.utils.LogUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import org.springframework.core.annotation.Order;

@Order(value=1)
@WebFilter(filterName="webFilter", urlPatterns={"/*"})
public class NacosWebFilter
implements Filter {
    private static String webRootPath;

    public static String rootPath() {
        return webRootPath;
    }

    public static void setWebRootPath(String path) {
        webRootPath = path;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext ctx = filterConfig.getServletContext();
        NacosWebFilter.setWebRootPath(ctx.getRealPath("/"));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        request.setCharacterEncoding("UTF-8");
        response.setContentType("application/json;charset=UTF-8");
        try {
            chain.doFilter(request, response);
        }
        catch (IOException ioe) {
            LogUtil.defaultLog.debug("Filter catch exception, " + ioe.toString(), (Throwable)ioe);
            throw ioe;
        }
        catch (ServletException se) {
            LogUtil.defaultLog.debug("Filter catch exception, " + se.toString(), (Throwable)se);
            throw se;
        }
    }

    public void destroy() {
    }
}

