/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.exception;

import com.alibaba.nacos.config.server.exception.NacosException;
import com.alibaba.nacos.config.server.monitor.MetricsMonitor;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class GlobalExceptionHandler {
    @ExceptionHandler(value={IllegalArgumentException.class})
    public void handleIllegalArgumentException(HttpServletResponse response, Exception ex) throws IOException {
        MetricsMonitor.getIllegalArgumentException().increment();
        response.setStatus(400);
        if (ex.getMessage() != null) {
            response.getWriter().println(ex.getMessage());
        } else {
            response.getWriter().println("invalid param");
        }
    }

    @ExceptionHandler(value={NacosException.class})
    public void handleNacosException(HttpServletResponse response, NacosException ex) throws IOException {
        MetricsMonitor.getNacosException().increment();
        response.setStatus(ex.getErrCode());
        if (ex.getErrMsg() != null) {
            response.getWriter().println(ex.getErrMsg());
        } else {
            response.getWriter().println("unknown exception");
        }
    }

    @ExceptionHandler(value={DataAccessException.class})
    public void handleDataAccessException(HttpServletResponse response, DataAccessException ex) throws DataAccessException {
        MetricsMonitor.getDbException().increment();
        throw new CannotGetJdbcConnectionException(ex.getMessage());
    }
}

