/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.common.util.SystemUtils;
import com.alibaba.nacos.config.server.model.CacheItem;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.service.ConfigService;
import com.alibaba.nacos.config.server.service.DiskUtil;
import com.alibaba.nacos.config.server.service.LongPollingService;
import com.alibaba.nacos.config.server.service.PersistService;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.MD5Util;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.config.server.utils.Protocol;
import com.alibaba.nacos.config.server.utils.RequestUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigServletInner {
    @Autowired
    private LongPollingService longPollingService;
    @Autowired
    private PersistService persistService;
    private static final int TRY_GET_LOCK_TIMES = 9;
    private static final int START_LONGPOLLING_VERSION_NUM = 204;

    public String doPollingConfig(HttpServletRequest request, HttpServletResponse response, Map<String, String> clientMd5Map, int probeRequestSize) throws IOException, ServletException {
        int versionNum;
        if (LongPollingService.isSupportLongPolling(request)) {
            this.longPollingService.addLongPollingClient(request, response, clientMd5Map, probeRequestSize);
            return "200";
        }
        List<String> changedGroups = MD5Util.compareMd5(request, response, clientMd5Map);
        String oldResult = MD5Util.compareMd5OldResult(changedGroups);
        String newResult = MD5Util.compareMd5ResultString(changedGroups);
        String version = request.getHeader("Client-Version");
        if (version == null) {
            version = "2.0.0";
        }
        if ((versionNum = Protocol.getVersionNumber(version)) < 204) {
            response.addHeader("Probe-Modify-Response", oldResult);
            response.addHeader("Probe-Modify-Response-New", newResult);
        } else {
            request.setAttribute("content", (Object)newResult);
        }
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setHeader("Cache-Control", "no-cache,no-store");
        response.setStatus(200);
        return "200";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGetConfig(HttpServletRequest request, HttpServletResponse response, String dataId, String group, String tenant, String tag, String clientIp) throws IOException, ServletException {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        String autoTag = request.getHeader("Vipserver-Tag");
        String requestIpApp = RequestUtil.getAppName(request);
        int lockResult = ConfigServletInner.tryConfigReadLock(request, response, groupKey);
        String requestIp = RequestUtil.getRemoteIp(request);
        boolean isBeta = false;
        if (lockResult > 0) {
            FileInputStream fis = null;
            try {
                String md5 = "";
                long lastModified = 0L;
                CacheItem cacheItem = ConfigService.getContentCache(groupKey);
                if (cacheItem != null && cacheItem.isBeta() && cacheItem.getIps4Beta().contains(clientIp)) {
                    isBeta = true;
                }
                File file = null;
                ConfigInfo configInfoBase = null;
                PrintWriter out = null;
                if (isBeta) {
                    md5 = cacheItem.getMd54Beta();
                    lastModified = cacheItem.getLastModifiedTs4Beta();
                    if (SystemUtils.STANDALONE_MODE && !PropertyUtil.isStandaloneUseMysql()) {
                        configInfoBase = this.persistService.findConfigInfo4Beta(dataId, group, tenant);
                    } else {
                        file = DiskUtil.targetBetaFile(dataId, group, tenant);
                    }
                    response.setHeader("isBeta", "true");
                } else if (StringUtils.isBlank((CharSequence)tag)) {
                    if (ConfigServletInner.isUseTag(cacheItem, autoTag)) {
                        if (cacheItem != null) {
                            if (cacheItem.tagMd5 != null) {
                                md5 = cacheItem.tagMd5.get(autoTag);
                            }
                            if (cacheItem.tagLastModifiedTs != null) {
                                lastModified = cacheItem.tagLastModifiedTs.get(autoTag);
                            }
                        }
                        if (SystemUtils.STANDALONE_MODE && !PropertyUtil.isStandaloneUseMysql()) {
                            configInfoBase = this.persistService.findConfigInfo4Tag(dataId, group, tenant, autoTag);
                        } else {
                            file = DiskUtil.targetTagFile(dataId, group, tenant, autoTag);
                        }
                        response.setHeader("Vipserver-Tag", URLEncoder.encode(autoTag, StandardCharsets.UTF_8.displayName()));
                    } else {
                        md5 = cacheItem.getMd5();
                        lastModified = cacheItem.getLastModifiedTs();
                        if (SystemUtils.STANDALONE_MODE && !PropertyUtil.isStandaloneUseMysql()) {
                            configInfoBase = this.persistService.findConfigInfo(dataId, group, tenant);
                        } else {
                            file = DiskUtil.targetFile(dataId, group, tenant);
                        }
                        if (configInfoBase == null && ConfigServletInner.fileNotExist(file)) {
                            ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, -1L, "not-found", -1L, requestIp);
                            response.setStatus(404);
                            response.getWriter().println("config data not exist");
                            String string = "404";
                            return string;
                        }
                    }
                } else {
                    Object lm;
                    if (cacheItem != null) {
                        if (cacheItem.tagMd5 != null) {
                            md5 = cacheItem.tagMd5.get(tag);
                        }
                        if (cacheItem.tagLastModifiedTs != null && (lm = cacheItem.tagLastModifiedTs.get(tag)) != null) {
                            lastModified = (Long)lm;
                        }
                    }
                    if (SystemUtils.STANDALONE_MODE && !PropertyUtil.isStandaloneUseMysql()) {
                        configInfoBase = this.persistService.findConfigInfo4Tag(dataId, group, tenant, tag);
                    } else {
                        file = DiskUtil.targetTagFile(dataId, group, tenant, tag);
                    }
                    if (configInfoBase == null && ConfigServletInner.fileNotExist(file)) {
                        ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, -1L, "not-found", -1L, requestIp);
                        response.setStatus(404);
                        response.getWriter().println("config data not exist");
                        lm = "404";
                        return lm;
                    }
                }
                response.setHeader("Content-MD5", md5);
                response.setHeader("Pragma", "no-cache");
                response.setDateHeader("Expires", 0L);
                response.setHeader("Cache-Control", "no-cache,no-store");
                if (SystemUtils.STANDALONE_MODE && !PropertyUtil.isStandaloneUseMysql()) {
                    response.setDateHeader("Last-Modified", lastModified);
                } else {
                    fis = new FileInputStream(file);
                    response.setDateHeader("Last-Modified", file.lastModified());
                }
                if (SystemUtils.STANDALONE_MODE && !PropertyUtil.isStandaloneUseMysql()) {
                    out = response.getWriter();
                    out.print(configInfoBase.getContent());
                    out.flush();
                    out.close();
                } else {
                    fis.getChannel().transferTo(0L, fis.getChannel().size(), Channels.newChannel((OutputStream)response.getOutputStream()));
                }
                LogUtil.pullCheckLog.warn("{}|{}|{}|{}", new Object[]{groupKey, requestIp, md5, TimeUtils.getCurrentTimeStr()});
                long delayed = System.currentTimeMillis() - lastModified;
                ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, lastModified, "ok", delayed, requestIp);
            }
            finally {
                ConfigServletInner.releaseConfigReadLock(groupKey);
                if (null != fis) {
                    fis.close();
                }
            }
        } else {
            if (lockResult == 0) {
                ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, -1L, "not-found", -1L, requestIp);
                response.setStatus(404);
                response.getWriter().println("config data not exist");
                return "404";
            }
            LogUtil.pullLog.info("[client-get] clientIp={}, {}, get data during dump", (Object)clientIp, (Object)groupKey);
            response.setStatus(409);
            response.getWriter().println("requested file is being modified, please try later.");
            return "409";
        }
        return "200";
    }

    private static void releaseConfigReadLock(String groupKey) {
        ConfigService.releaseReadLock(groupKey);
    }

    private static int tryConfigReadLock(HttpServletRequest request, HttpServletResponse response, String groupKey) throws IOException, ServletException {
        int lockResult = -1;
        for (int i = 9; i >= 0 && 0 != (lockResult = ConfigService.tryReadLock(groupKey)) && lockResult <= 0; --i) {
            if (i <= 0) continue;
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lockResult;
    }

    private static boolean isUseTag(CacheItem cacheItem, String tag) {
        if (cacheItem != null && cacheItem.tagMd5 != null && cacheItem.tagMd5.size() > 0) {
            return StringUtils.isNotBlank((CharSequence)tag) && cacheItem.tagMd5.containsKey(tag);
        }
        return false;
    }

    private static boolean fileNotExist(File file) {
        return file == null || !file.exists();
    }
}

