/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.util;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SystemUtils {
    public static final String STANDALONE_MODE_PROPERTY_NAME = "nacos.standalone";
    public static final boolean STANDALONE_MODE = Boolean.getBoolean("nacos.standalone");
    private static OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();

    public static List<String> getIPsBySystemEnv(String key) {
        String env = SystemUtils.getSystemEnv(key);
        List<String> ips = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)env)) {
            ips = Arrays.asList(env.split(","));
        }
        return ips;
    }

    public static String getSystemEnv(String key) {
        String env = System.getenv(key);
        return env;
    }

    public static float getLoad() {
        return (float)operatingSystemMXBean.getSystemLoadAverage();
    }

    public static float getCPU() {
        return (float)operatingSystemMXBean.getSystemCpuLoad();
    }

    public static float getMem() {
        return (float)(1.0 - (double)operatingSystemMXBean.getFreePhysicalMemorySize() / (double)operatingSystemMXBean.getTotalPhysicalMemorySize());
    }
}

