/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.akali.strategy;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.DigestUtil;
import com.alibaba.csp.sentinel.util.MethodUtil;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import org.dromara.akali.enums.AkaliStrategyEnum;
import org.dromara.akali.strategy.AkaliStrategy;

public class MethodHotspotStrategy
implements AkaliStrategy {
    private TimedCache<String, Object> timedCache = CacheUtil.newTimedCache((long)60000L);

    public MethodHotspotStrategy() {
        this.timedCache.schedulePrune(1000L);
    }

    @Override
    public AkaliStrategyEnum getStrategy() {
        return AkaliStrategyEnum.HOT_METHOD;
    }

    @Override
    public Object process(Object bean, Method method, Object[] args) throws Exception {
        String hotKey = StrUtil.format((CharSequence)"{}-{}", (Object[])new Object[]{MethodUtil.resolveMethodName((Method)method), DigestUtil.md5Hex((String)JSON.toJSONString((Object)args))});
        if (this.timedCache.containsKey((Object)hotKey)) {
            return this.timedCache.get((Object)hotKey);
        }
        Object result = method.invoke(bean, args);
        this.timedCache.put((Object)hotKey, result);
        return result;
    }
}

