/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.akali.strategy;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dromara.akali.enums.AkaliStrategyEnum;
import org.dromara.akali.strategy.AkaliStrategy;

public class FallbackStrategy
implements AkaliStrategy {
    private final Map<String, Method> fallBackMethodMap = new ConcurrentHashMap<String, Method>();

    @Override
    public AkaliStrategyEnum getStrategy() {
        return AkaliStrategyEnum.FALLBACK;
    }

    @Override
    public Object process(Object bean, Method method, Object[] args) throws Exception {
        Method fallbackMethod;
        String fallbackMethodName = StrUtil.format((CharSequence)"{}Fallback", (Object[])new Object[]{method.getName()});
        if (this.fallBackMethodMap.containsKey(fallbackMethodName)) {
            fallbackMethod = this.fallBackMethodMap.get(fallbackMethodName);
        } else {
            fallbackMethod = ReflectUtil.getMethod(bean.getClass(), (String)fallbackMethodName, (Class[])method.getParameterTypes());
            this.fallBackMethodMap.put(fallbackMethodName, fallbackMethod);
        }
        if (ObjectUtil.isNull((Object)fallbackMethod)) {
            throw new RuntimeException(StrUtil.format((CharSequence)"[AKALI] Can't find fallback method [{}] in bean [{}]", (Object[])new Object[]{fallbackMethodName, bean.getClass().getName()}));
        }
        return fallbackMethod.invoke(bean, args);
    }
}

