/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.akali.spring;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.csp.sentinel.util.MethodUtil;
import com.alibaba.csp.sentinel.util.function.Tuple2;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dromara.akali.annotation.AkaliFallback;
import org.dromara.akali.annotation.AkaliHot;
import org.dromara.akali.enums.AkaliStrategyEnum;
import org.dromara.akali.manager.AkaliMethodManager;
import org.dromara.akali.manager.AkaliStrategyManager;
import org.dromara.akali.proxy.AkaliByteBuddyProxy;
import org.dromara.akali.strategy.AkaliStrategy;
import org.dromara.akali.util.ProxyUtil;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;

public class AkaliScanner
implements InstantiationAwareBeanPostProcessor {
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz = ProxyUtil.getUserClass(bean.getClass());
        if (AkaliStrategy.class.isAssignableFrom(clazz)) {
            AkaliStrategyManager.addStrategy((AkaliStrategy)bean);
            return bean;
        }
        AtomicBoolean needProxy = new AtomicBoolean(false);
        ArrayList<Method> fallbackMethodList = new ArrayList<Method>();
        ArrayList<Method> hotspotMethodList = new ArrayList<Method>();
        Arrays.stream(clazz.getMethods()).forEach(method -> {
            AkaliHot akaliHot;
            AkaliFallback akaliFallback = this.searchAnnotation((Method)method, (Class)AkaliFallback.class);
            if (ObjectUtil.isNotNull((Object)akaliFallback)) {
                fallbackMethodList.add((Method)method);
                AkaliMethodManager.addMethodStr(MethodUtil.resolveMethodName((Method)method), (Tuple2<AkaliStrategyEnum, Annotation>)new Tuple2((Object)AkaliStrategyEnum.FALLBACK, (Object)akaliFallback));
                needProxy.set(true);
            }
            if (ObjectUtil.isNotNull((Object)(akaliHot = this.searchAnnotation((Method)method, (Class)AkaliHot.class)))) {
                hotspotMethodList.add((Method)method);
                AkaliMethodManager.addMethodStr(MethodUtil.resolveMethodName((Method)method), (Tuple2<AkaliStrategyEnum, Annotation>)new Tuple2((Object)AkaliStrategyEnum.HOT_METHOD, (Object)akaliHot));
                needProxy.set(true);
            }
        });
        if (needProxy.get()) {
            try {
                AkaliByteBuddyProxy akaliProxy = new AkaliByteBuddyProxy(bean, clazz, fallbackMethodList, hotspotMethodList);
                return akaliProxy.proxy();
            }
            catch (Exception e) {
                throw new BeanInitializationException(e.getMessage());
            }
        }
        return bean;
    }

    private <A extends Annotation> A searchAnnotation(Method method, Class<A> annotationType) {
        Annotation anno = AnnotationUtil.getAnnotation((AnnotatedElement)method, annotationType);
        if (anno == null) {
            Class<?>[] ifaces;
            for (Class<?> ifaceClass : ifaces = method.getDeclaringClass().getInterfaces()) {
                Method ifaceMethod = ReflectUtil.getMethod(ifaceClass, (String)method.getName(), (Class[])method.getParameterTypes());
                if (ifaceMethod == null) continue;
                anno = this.searchAnnotation(ifaceMethod, annotationType);
                break;
            }
        }
        if (anno == null) {
            Class<?> superClazz = method.getDeclaringClass().getSuperclass();
            if (superClazz != null) {
                Method superMethod = ReflectUtil.getMethod(superClazz, (String)method.getName(), (Class[])method.getParameterTypes());
                if (superMethod != null) {
                    return this.searchAnnotation(superMethod, annotationType);
                }
                return null;
            }
            return null;
        }
        return (A)anno;
    }
}

