/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.akali.sph;

import cn.hutool.crypto.digest.DigestUtil;
import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphO;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import org.dromara.akali.enums.AkaliStrategyEnum;
import org.dromara.akali.manager.AkaliStrategyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SphEngine {
    private static final Logger log = LoggerFactory.getLogger(SphEngine.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object process(Object bean, Method method, Object[] args, String methodStr, AkaliStrategyEnum akaliStrategyEnum) throws Throwable {
        switch (akaliStrategyEnum) {
            case FALLBACK: {
                if (SphO.entry((String)methodStr)) {
                    try {
                        Object object = method.invoke(bean, args);
                        return object;
                    }
                    finally {
                        SphO.exit();
                    }
                }
                log.info("[AKALI]Trigger fallback strategy for [{}]", (Object)methodStr);
                return AkaliStrategyManager.getStrategy(akaliStrategyEnum).process(bean, method, args);
            }
            case HOT_METHOD: {
                Object object;
                String convertParam = DigestUtil.md5Hex((String)JSON.toJSONString((Object)args));
                Entry entry = null;
                try {
                    entry = SphU.entry((String)methodStr, (EntryType)EntryType.IN, (int)1, (Object[])new Object[]{convertParam});
                    object = method.invoke(bean, args);
                    if (entry == null) return object;
                }
                catch (BlockException e) {
                    Object object2;
                    try {
                        log.info("[AKALI]Trigger hotspot strategy for [{}]", (Object)methodStr);
                        object2 = AkaliStrategyManager.getStrategy(akaliStrategyEnum).process(bean, method, args);
                        if (entry == null) return object2;
                    }
                    catch (Throwable throwable) {
                        if (entry == null) throw throwable;
                        entry.exit(1, new Object[]{convertParam});
                        throw throwable;
                    }
                    entry.exit(1, new Object[]{convertParam});
                    return object2;
                }
                entry.exit(1, new Object[]{convertParam});
                return object;
            }
        }
        throw new Exception("[AKALI] Strategy error!");
    }
}

