/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.akali.proxy;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.csp.sentinel.util.MethodUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.implementation.attribute.MethodAttributeAppender;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.dromara.akali.annotation.AkaliFallback;
import org.dromara.akali.annotation.AkaliHot;
import org.dromara.akali.enums.AkaliStrategyEnum;
import org.dromara.akali.manager.AkaliMethodManager;
import org.dromara.akali.manager.AkaliRuleManager;
import org.dromara.akali.sph.SphEngine;
import org.dromara.akali.util.SerialsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AkaliByteBuddyProxy {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Object bean;
    private final Class<?> originalClazz;
    private final List<Method> fallbackMethodList;
    private final List<Method> hotspotMethodList;

    public AkaliByteBuddyProxy(Object bean, Class<?> originalClazz, List<Method> fallbackMethodList, List<Method> hotspotMethodList) {
        this.bean = bean;
        this.originalClazz = originalClazz;
        this.fallbackMethodList = fallbackMethodList;
        this.hotspotMethodList = hotspotMethodList;
    }

    public Object proxy() throws Exception {
        Collection methodList = CollUtil.union(this.fallbackMethodList, this.hotspotMethodList);
        return new ByteBuddy().subclass(this.originalClazz).name(StrUtil.format((CharSequence)"{}$ByteBuddy${}", (Object[])new Object[]{this.bean.getClass().getName(), SerialsUtil.generateShortUUID()})).method((ElementMatcher)ElementMatchers.namedOneOf((String[])((String[])methodList.stream().map(Method::getName).toArray(String[]::new)))).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)new AopInvocationHandler())).attribute((MethodAttributeAppender.Factory)MethodAttributeAppender.ForInstrumentedMethod.INCLUDING_RECEIVER).annotateType(this.bean.getClass().getAnnotations()).make().load(AkaliByteBuddyProxy.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded().newInstance();
    }

    public class AopInvocationHandler
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodStr = MethodUtil.resolveMethodName((Method)method);
            if (AkaliMethodManager.contain(methodStr)) {
                AkaliStrategyEnum akaliStrategyEnum = (AkaliStrategyEnum)((Object)AkaliMethodManager.getAnnoInfo((String)methodStr).r1);
                Annotation anno = (Annotation)AkaliMethodManager.getAnnoInfo((String)methodStr).r2;
                if (anno instanceof AkaliFallback) {
                    AkaliRuleManager.registerFallbackRule((AkaliFallback)anno, method);
                } else if (anno instanceof AkaliHot) {
                    AkaliRuleManager.registerHotRule((AkaliHot)anno, method);
                } else {
                    throw new RuntimeException("annotation type error");
                }
                return SphEngine.process(AkaliByteBuddyProxy.this.bean, method, args, methodStr, akaliStrategyEnum);
            }
            return method.invoke(AkaliByteBuddyProxy.this.bean, args);
        }
    }
}

