/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.akali.manager;

import cn.hutool.core.collection.ListUtil;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.csp.sentinel.util.MethodUtil;
import java.lang.reflect.Method;
import java.util.List;
import org.dromara.akali.annotation.AkaliFallback;
import org.dromara.akali.annotation.AkaliHot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AkaliRuleManager {
    private static final Logger log = LoggerFactory.getLogger(AkaliRuleManager.class);

    public static void registerFallbackRule(AkaliFallback akaliFallback, Method method) {
        String resourceKey = MethodUtil.resolveMethodName((Method)method);
        if (!FlowRuleManager.hasConfig((String)resourceKey)) {
            FlowRule rule = new FlowRule();
            rule.setResource(resourceKey);
            rule.setGrade(akaliFallback.grade().getGrade());
            rule.setCount((double)akaliFallback.count());
            rule.setLimitApp("default");
            FlowRuleManager.loadRules((List)ListUtil.toList((Object[])new FlowRule[]{rule}));
            log.info("[AKALI] Add Fallback Rule [{}]", (Object)resourceKey);
        }
    }

    public static void registerHotRule(AkaliHot akaliHot, Method method) {
        String resourceKey = MethodUtil.resolveMethodName((Method)method);
        if (!ParamFlowRuleManager.hasRules((String)resourceKey)) {
            ParamFlowRule rule = new ParamFlowRule();
            rule.setResource(MethodUtil.resolveMethodName((Method)method));
            rule.setGrade(akaliHot.grade().getGrade());
            rule.setCount((double)akaliHot.count());
            rule.setDurationInSec((long)akaliHot.duration());
            rule.setParamIdx(Integer.valueOf(0));
            ParamFlowRuleManager.loadRules((List)ListUtil.toList((Object[])new ParamFlowRule[]{rule}));
            log.info("[AKALI] Add Hot Rule [{}]", (Object)rule.getResource());
        }
    }
}

