/*
 * Decompiled with CFR 0.152.
 */
package com.zto.zop;

import com.zto.zop.EncryptionType;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class ZopDigestUtil {
    private static final String HMAC_SHA_256 = "HmacSHA256";
    private static final Map<String, Mac> MAC_MAP = new ConcurrentHashMap<String, Mac>();

    public static String digest(String str, Boolean isBase64, EncryptionType encryptionType, Long timestamp, String secretKey) {
        if (timestamp != null) {
            str = timestamp + str;
        }
        boolean base64 = isBase64 == null || isBase64 != false;
        switch (encryptionType) {
            case SHA256: {
                return base64 ? Base64.encodeBase64String((byte[])DigestUtils.sha256((String)str)) : DigestUtils.sha256Hex((String)str);
            }
            case HmacSHA256: {
                return base64 ? Base64.encodeBase64String((byte[])ZopDigestUtil.hmacSha256(secretKey, str)) : ZopDigestUtil.hmacSha256Str(secretKey, str);
            }
        }
        return base64 ? Base64.encodeBase64String((byte[])DigestUtils.md5((String)str)) : DigestUtils.md5Hex((String)str);
    }

    public static String hmacSha256Str(String key, String body) {
        return Hex.encodeHexString((byte[])ZopDigestUtil.hmacSha256(key, body));
    }

    public static byte[] hmacSha256(String key, String body) {
        Mac mac;
        if (Objects.isNull(key)) {
            key = "";
        }
        if ((mac = MAC_MAP.get(key)) == null) {
            try {
                mac = Mac.getInstance(HMAC_SHA_256);
                SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), HMAC_SHA_256);
                mac.init(secretKey);
                MAC_MAP.put(key, mac);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return mac.doFinal(body.getBytes(StandardCharsets.UTF_8));
    }
}

