/*
 * Decompiled with CFR 0.152.
 */
package com.theproject.kit.actuator.dubbo.autoconfigure;

import com.alibaba.dubbo.config.RegistryConfig;
import com.theproject.kit.actuator.config.ActuatorPortInit;
import com.theproject.kit.actuator.dubbo.health.biz.DubboHealthBizData;
import io.micrometer.core.instrument.MeterRegistry;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnBean(value={RegistryConfig.class})
public class DubboCheckerAutoConfiguration {
    private static Map<String, String> ENV_MAP = new HashMap<String, String>();

    @Bean
    public ActuatorPortInit actuatorPortInit(ManagementServerProperties managementServerProperties) {
        return new ActuatorPortInit(managementServerProperties);
    }

    @Bean
    public MeterRegistryCustomizer<MeterRegistry> metricsCommonTags(Environment environment, MeterRegistry registry) {
        String appId = environment.getProperty("app.id");
        if (StringUtils.isBlank((CharSequence)appId)) {
            throw new RuntimeException("[project-kit-actuator] App ID does not exist!");
        }
        DubboHealthBizData.setRegistry(registry);
        String env = environment.getProperty("env");
        return r -> {
            try {
                r.config().commonTags(new String[]{"application", appId});
                if (StringUtils.isNotBlank((CharSequence)env)) {
                    r.config().commonTags(new String[]{"env", ENV_MAP.get(env)});
                }
                InetAddress inetAddress = InetAddress.getLocalHost();
                r.config().commonTags(new String[]{"hostname", inetAddress.getHostName()});
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        };
    }

    static {
        ENV_MAP.put("local", "local");
        ENV_MAP.put("fat", "test");
        ENV_MAP.put("uat", "pre");
        ENV_MAP.put("pro", "prod");
    }
}

