package com.theproject.kit.actuator.dubbo.prometheus.binder.bean;

import com.theproject.kit.actuator.dubbo.checker.DubboCheckerService;
import com.theproject.kit.actuator.dubbo.prometheus.binder.DubboInvokeHealthBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Resource;

public class DubboInvokeHealthBinderBean {

    private Logger log = LoggerFactory.getLogger(DubboInvokeHealthBinder.class);

    private final static String OK = "ok";

    @Resource
    private DubboCheckerService dubboCheckerConsumerService;

    public Integer getInvokeHealthResult(){
        String result = null;
        try {
            result = dubboCheckerConsumerService.check();
        }catch (Throwable t){
            log.error("[project-kit-actuator] 调用Dubbo检查接口失败，服务可能不可用! 由于: \n" + t.getMessage(),t);
        }

        Integer gaugeResult = OK.equals(result) ? 1 : 0;
        return gaugeResult;
    }
}
