package com.theproject.kit.actuator.dubbo.prometheus.binder;

import com.theproject.kit.actuator.dubbo.checker.DubboCheckerService;
import com.theproject.kit.actuator.dubbo.prometheus.binder.bean.DubboInvokeHealthBinderBean;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;

public class DubboInvokeHealthBinder implements MeterBinder {

    private DubboInvokeHealthBinderBean dubboInvokeHealthBinderBean;

    public DubboInvokeHealthBinder(DubboInvokeHealthBinderBean dubboInvokeHealthBinderBean){
        this.dubboInvokeHealthBinderBean = dubboInvokeHealthBinderBean;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Tags tags = Tags.of("dubbo", "health");

        Gauge.builder("dubbo.health.invoke", dubboInvokeHealthBinderBean, DubboInvokeHealthBinderBean::getInvokeHealthResult)
                .tags(tags)
                .description("check whether dubbo can be invoked")
                .register(registry);
    }
}
