package com.theproject.kit.actuator.dubbo.prometheus.binder;

import com.theproject.kit.actuator.dubbo.prometheus.binder.bean.DubboHealthBinderBean;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import org.springframework.beans.factory.annotation.Autowired;

public class DubboHealthBinder implements MeterBinder {

    private DubboHealthBinderBean dubboHealthBinderBean;

    public DubboHealthBinder(DubboHealthBinderBean dubboHealthBinderBean) {
        this.dubboHealthBinderBean = dubboHealthBinderBean;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Gauge.builder("dubbo_health", dubboHealthBinderBean, bean -> bean.getStatus())
                .register(registry);
    }
}
