package com.theproject.kit.actuator.dubbo.checker.config;

import com.alibaba.dubbo.config.ServiceConfig;
import com.theproject.kit.actuator.dubbo.checker.DubboCheckerService;
import com.theproject.kit.actuator.dubbo.checker.DubboCheckerServiceImpl;
import com.theproject.kit.actuator.dubbo.health.biz.DubboHealthBizData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;


public class DubboCheckProviderInit implements InitializingBean {

    private Logger log = LoggerFactory.getLogger(this.getClass());

    private DubboCheckerService ref = new DubboCheckerServiceImpl();

    @Autowired
    private DubboMetaBeanGetter dubboMetaBeanGetter;

    @Override
    public void afterPropertiesSet() {
        ServiceConfig<DubboCheckerService> service = new ServiceConfig<>();
        service.setApplication(dubboMetaBeanGetter.getApplicationConfig());
        service.setRegistry(dubboMetaBeanGetter.getRegistryConfig());
        service.setProtocol(dubboMetaBeanGetter.getProtocolConfig());
        service.setInterface(DubboCheckerService.class);
        service.setRef(ref);
        service.export();
        log.info("DubboCheckerService has bean exported");
    }
}
