package com.theproject.kit.actuator.dubbo.checker.config;

import com.alibaba.dubbo.config.ReferenceConfig;
import com.theproject.kit.actuator.dubbo.checker.DubboCheckerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

public class DubboCheckConsumerFactoryBean implements FactoryBean<DubboCheckerService> {

    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private DubboMetaBeanGetter dubboMetaBeanGetter;

    @Override
    public DubboCheckerService getObject() throws Exception {
        ReferenceConfig<DubboCheckerService> reference = new ReferenceConfig<>();
        reference.setApplication(dubboMetaBeanGetter.getApplicationConfig());
        reference.setRegistry(dubboMetaBeanGetter.getRegistryConfig());
        reference.setInterface(DubboCheckerService.class);
        reference.setTimeout(500);
        reference.setRetries(0);
        reference.setId("dubboCheckerService");
        DubboCheckerService service = reference.get();
        log.info("DubboCheckerService test consumer invoke:{}" + service.check());
        return service;
    }

    @Override
    public Class<?> getObjectType() {
        return DubboCheckerService.class;
    }
}
