/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.service;

import com.thebeastshop.scm.dao.InvOccupyDao;
import com.thebeastshop.scm.dao.InvRcdDao;
import com.thebeastshop.scm.dao.PresaleDao;
import com.thebeastshop.scm.dao.ProductDao;
import com.thebeastshop.scm.dao.SkuCategoryFrontRelationDao;
import com.thebeastshop.scm.dao.SoPackageSkuDao;
import com.thebeastshop.scm.service.core.BaseService;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class StockService
extends BaseService {
    @Resource
    private ProductDao productDao;
    @Resource
    private SkuCategoryFrontRelationDao skuCategoryFrontRelationDao;
    @Resource
    private PresaleDao presaleDao;
    @Resource
    private InvOccupyDao whInvOccupyDao;
    @Resource
    private InvRcdDao whInvRcdDao;
    @Resource
    private SoPackageSkuDao soPackageSkuDao;
    private static final String FLOWER_WARE_HOUSE_CODE = "WH020600020002";
    private static final String NEW_WEBSITE_HOUSE_CODE = "WH020600010102";

    public int bySkuCode(String skuCode) {
        List<String> skuCodeList = Arrays.asList(skuCode);
        return this.bySkuCode(skuCodeList);
    }

    public int byProductId(Integer productId) {
        List skuCodes = this.productDao.getSkuCodeById(productId);
        return this.bySkuCode(skuCodes);
    }

    private int bySkuCode(List<String> skuCodes) {
        int salePresale;
        int presaleQuantity = this.presaleDao.getPresaleBySkuCodes(skuCodes);
        int presaleStock = presaleQuantity - (salePresale = this.soPackageSkuDao.getQuantityBySkuCode(skuCodes).intValue());
        if (presaleStock < 0) {
            this.log.warn("-------\u9884\u552e\u5e93\u5b58\u5c0f\u4e8e0,\u6570\u636e\u5f02\u5e38-------------------");
            presaleStock = 0;
        }
        String wareHouseCode = NEW_WEBSITE_HOUSE_CODE;
        if (this.skuCategoryFrontRelationDao.isFlowerBySkuCode(skuCodes)) {
            wareHouseCode = FLOWER_WARE_HOUSE_CODE;
        }
        int invRcd = this.whInvRcdDao.getInvRcdQuantityBySkuCodeAndWareHouseCode(skuCodes, wareHouseCode);
        int invOccupy = this.whInvOccupyDao.getInvOccupyQuantityBySkuCodesAndWarehouseCode(skuCodes, wareHouseCode);
        return presaleStock + invRcd - invOccupy;
    }
}

